/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import io.deephaven.auth.AnonymousAuthenticationHandler;
import io.deephaven.auth.AuthContext;
import io.deephaven.auth.AuthenticationException;
import io.deephaven.auth.AuthenticationRequestHandler;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;

public class BasicAuthMarshaller
implements AuthenticationRequestHandler {
    public static final String AUTH_TYPE = "Basic ".trim();
    private static final Logger log = LoggerFactory.getLogger(AnonymousAuthenticationHandler.class);
    private final Handler handler;

    public BasicAuthMarshaller(Handler handler) {
        this.handler = handler;
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public void initialize(String targetUrl) {
        log.info().append((CharSequence)"================================================================================").endl();
        log.info().append((CharSequence)"Basic Authentication is enabled.").endl();
        log.info().append((CharSequence)"       Listening on ").append((CharSequence)targetUrl).endl();
        log.info().append((CharSequence)"================================================================================").endl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<AuthContext> login(long protocolVersion, ByteBuffer payload, AuthenticationRequestHandler.HandshakeResponseListener listener) throws AuthenticationException {
        CodedInputStream inputStream = CodedInputStream.newInstance((ByteBuffer)payload);
        String username = null;
        String password = null;
        try {
            block6: while (!inputStream.isAtEnd()) {
                int tag = inputStream.readTag();
                switch (WireFormat.getTagFieldNumber((int)tag)) {
                    case 2: {
                        if (username == null && WireFormat.getTagWireType((int)tag) == 2) {
                            username = inputStream.readString();
                            continue block6;
                        }
                        return Optional.empty();
                    }
                    case 3: {
                        if (password == null && WireFormat.getTagWireType((int)tag) == 2) {
                            password = inputStream.readString();
                            continue block6;
                        }
                        return Optional.empty();
                    }
                }
                return Optional.empty();
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        if (username != null && password != null) {
            return this.handler.login(username, password);
        }
        return Optional.empty();
    }

    @Override
    public Optional<AuthContext> login(String payload, AuthenticationRequestHandler.MetadataResponseListener listener) throws AuthenticationException {
        String authDecoded = new String(Base64.getDecoder().decode(payload), StandardCharsets.UTF_8);
        int colonPos = authDecoded.indexOf(58);
        if (colonPos == -1) {
            return Optional.empty();
        }
        String username = authDecoded.substring(0, colonPos);
        String password = authDecoded.substring(colonPos + 1);
        return this.handler.login(username, password);
    }

    public static interface Handler {
        public Optional<AuthContext> login(String var1, String var2) throws AuthenticationException;
    }
}

