/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.clock;

import io.deephaven.base.clock.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public final class DeltaClock
implements Clock {
    private final Clock delegate;
    private final long deltaNanos;

    public static DeltaClock of(Duration duration) {
        return new DeltaClock(duration.toNanos());
    }

    public DeltaClock(long deltaNanos) {
        this(Clock.system(), deltaNanos);
    }

    public DeltaClock(Clock delegate, long deltaNanos) {
        this.delegate = Objects.requireNonNull(delegate);
        this.deltaNanos = deltaNanos;
    }

    @Override
    public long currentTimeMillis() {
        return Math.addExact(this.delegate.currentTimeMillis(), this.deltaNanos / 1000000L);
    }

    @Override
    public long currentTimeMicros() {
        return Math.addExact(this.delegate.currentTimeMicros(), this.deltaNanos / 1000L);
    }

    @Override
    public long currentTimeNanos() {
        return Math.addExact(this.delegate.currentTimeNanos(), this.deltaNanos);
    }

    @Override
    public Instant instantNanos() {
        return this.delegate.instantNanos().plusNanos(this.deltaNanos);
    }

    @Override
    public Instant instantMillis() {
        return this.delegate.instantMillis().plusNanos(this.deltaNanos);
    }
}

