/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.clock;

import io.deephaven.base.clock.SystemClock;
import java.time.Instant;

public enum SystemClockMillis implements SystemClock
{
    INSTANCE;


    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    @Override
    public long currentTimeNanos() {
        return System.currentTimeMillis() * 1000000L;
    }

    @Override
    public Instant instantNanos() {
        return Instant.ofEpochMilli(System.currentTimeMillis());
    }

    @Override
    public Instant instantMillis() {
        return Instant.ofEpochMilli(System.currentTimeMillis());
    }
}

