/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.clock;

import io.deephaven.base.clock.Clock;
import io.deephaven.base.clock.SystemClockMillis;
import io.deephaven.base.clock.SystemClockUtc;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface SystemClock
extends Clock {
    public static final String KEY = "deephaven.systemClock";
    public static final String DEFAULT = "default";
    public static final String SERVICE_LOADER = "serviceLoader";
    public static final String SYSTEM_UTC = "systemUTC";
    public static final String SYSTEM_MILLIS = "systemMillis";

    public static SystemClock of() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String value;
        switch (value = System.getProperty(KEY, DEFAULT)) {
            case "default": {
                return SystemClock.serviceLoader().orElse(SystemClock.systemUTC());
            }
            case "serviceLoader": {
                return SystemClock.serviceLoader().orElseThrow(() -> new IllegalStateException("Unable to load clock"));
            }
            case "systemUTC": {
                return SystemClock.systemUTC();
            }
            case "systemMillis": {
                return SystemClock.systemMillis();
            }
        }
        return (SystemClock)Class.forName(value).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static SystemClock systemUTC() {
        return SystemClockUtc.INSTANCE;
    }

    public static SystemClock systemMillis() {
        return SystemClockMillis.INSTANCE;
    }

    public static Optional<SystemClock> serviceLoader() {
        SystemClock impl;
        Iterator<SystemClock> it = ServiceLoader.load(SystemClock.class).iterator();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        try {
            impl = it.next();
        }
        catch (ServiceConfigurationError e) {
            e.printStackTrace(System.err);
            return Optional.empty();
        }
        if (it.hasNext()) {
            throw new IllegalStateException("More than one SystemClock has been registered as ServiceLoader implementation");
        }
        return Optional.of(impl);
    }
}

