/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.clock;

import io.deephaven.base.clock.SystemClock;
import java.time.Clock;
import java.time.Instant;

public enum SystemClockUtc implements SystemClock
{
    INSTANCE;


    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        Instant now = Clock.systemUTC().instant();
        return now.getEpochSecond() * 1000000L + (long)(now.getNano() / 1000);
    }

    @Override
    public long currentTimeNanos() {
        Instant now = Clock.systemUTC().instant();
        return now.getEpochSecond() * 1000000000L + (long)now.getNano();
    }

    @Override
    public Instant instantNanos() {
        return Clock.systemUTC().instant();
    }

    @Override
    public Instant instantMillis() {
        return Instant.ofEpochMilli(System.currentTimeMillis());
    }
}

