/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv;

import io.deephaven.csv.ImmutableCsvSpecs;
import io.deephaven.csv.annotations.BuildableStyle;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.parsers.Parsers;
import io.deephaven.csv.tokenization.JdkDoubleParser;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.Renderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Immutable
@BuildableStyle
public abstract class CsvSpecs {
    public static Builder builder() {
        return ImmutableCsvSpecs.builder();
    }

    @Value.Check
    void check() {
        ArrayList<String> problems = new ArrayList<String>();
        CsvSpecs.check7BitAscii("quote", this.quote(), problems);
        CsvSpecs.check7BitAscii("delimiter", this.delimiter(), problems);
        CsvSpecs.checkNonnegative("skipRows", this.skipRows(), problems);
        CsvSpecs.checkNonnegative("skipHeaderRows", this.skipHeaderRows(), problems);
        CsvSpecs.checkNonnegative("numRows", this.numRows(), problems);
        if (!this.hasHeaderRow() && this.skipHeaderRows() > 0L) {
            problems.add("skipHeaderRows != 0 but hasHeaderRow is not set");
        }
        if (problems.isEmpty()) {
            return;
        }
        String message = "CsvSpecs failed validation for the following reasons: " + Renderer.renderList(problems);
        throw new RuntimeException(message);
    }

    public static CsvSpecs csv() {
        return CsvSpecs.builder().build();
    }

    public static CsvSpecs tsv() {
        return CsvSpecs.builder().delimiter('\t').build();
    }

    public static CsvSpecs headerless() {
        return CsvSpecs.builder().hasHeaderRow(false).build();
    }

    public abstract List<String> headers();

    public abstract Map<Integer, String> headerForIndex();

    @Value.Default
    public List<Parser<?>> parsers() {
        return Parsers.DEFAULT;
    }

    public abstract Map<String, Parser<?>> parserForName();

    public abstract Map<Integer, Parser<?>> parserForIndex();

    @Value.Default
    public List<String> nullValueLiterals() {
        return Collections.singletonList("");
    }

    public abstract Map<String, List<String>> nullValueLiteralsForName();

    public abstract Map<Integer, List<String>> nullValueLiteralsForIndex();

    @Value.Default
    @Nullable
    public Parser<?> nullParser() {
        return Parsers.STRING;
    }

    @Value.Default
    public Tokenizer.CustomDoubleParser customDoubleParser() {
        return Tokenizer.CustomDoubleParser.load().orElse(JdkDoubleParser.INSTANCE);
    }

    @Value.Default
    @Nullable
    public Tokenizer.CustomTimeZoneParser customTimeZoneParser() {
        return null;
    }

    @Value.Default
    public Function<String[], String[]> headerLegalizer() {
        return Function.identity();
    }

    @Value.Default
    public Predicate<String> headerValidator() {
        return c -> true;
    }

    @Value.Default
    public long skipRows() {
        return 0L;
    }

    @Value.Default
    public long numRows() {
        return Long.MAX_VALUE;
    }

    @Value.Default
    public boolean ignoreEmptyLines() {
        return false;
    }

    @Value.Default
    public boolean allowMissingColumns() {
        return false;
    }

    @Value.Default
    public boolean ignoreExcessColumns() {
        return false;
    }

    @Value.Default
    public boolean hasHeaderRow() {
        return true;
    }

    @Value.Default
    public long skipHeaderRows() {
        return 0L;
    }

    @Value.Default
    public char delimiter() {
        return ',';
    }

    @Value.Default
    public char quote() {
        return '\"';
    }

    @Value.Default
    public boolean ignoreSurroundingSpaces() {
        return true;
    }

    @Value.Default
    public boolean trim() {
        return false;
    }

    @Value.Default
    public boolean concurrent() {
        return true;
    }

    private static void check7BitAscii(String what, char c, List<String> problems) {
        if (c > '\u007f') {
            String message = String.format("%s is set to '%c' but is required to be 7-bit ASCII", what, Character.valueOf(c));
            problems.add(message);
        }
    }

    private static void checkNonnegative(String what, long value, List<String> problems) {
        if (value < 0L) {
            String message = String.format("%s is set to %d, but is required to be nonnegative", what, value);
            problems.add(message);
        }
    }

    public static interface Builder {
        public Builder from(CsvSpecs var1);

        public Builder headers(Iterable<String> var1);

        public Builder putHeaderForIndex(int var1, String var2);

        public Builder parsers(Iterable<? extends Parser<?>> var1);

        public Builder putParserForName(String var1, Parser<?> var2);

        public Builder putParserForIndex(int var1, Parser<?> var2);

        public Builder nullValueLiterals(Iterable<String> var1);

        public Builder putNullValueLiteralsForName(String var1, List<String> var2);

        public Builder putNullValueLiteralsForIndex(int var1, List<String> var2);

        public Builder nullParser(Parser<?> var1);

        public Builder customDoubleParser(Tokenizer.CustomDoubleParser var1);

        public Builder customTimeZoneParser(Tokenizer.CustomTimeZoneParser var1);

        public Builder headerLegalizer(Function<String[], String[]> var1);

        public Builder headerValidator(Predicate<String> var1);

        public Builder skipRows(long var1);

        public Builder numRows(long var1);

        public Builder ignoreEmptyLines(boolean var1);

        public Builder allowMissingColumns(boolean var1);

        public Builder ignoreExcessColumns(boolean var1);

        public Builder hasHeaderRow(boolean var1);

        public Builder skipHeaderRows(long var1);

        public Builder delimiter(char var1);

        public Builder quote(char var1);

        public Builder ignoreSurroundingSpaces(boolean var1);

        public Builder trim(boolean var1);

        public Builder concurrent(boolean var1);

        public CsvSpecs build();
    }
}

