/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.MutableObject;
import org.jetbrains.annotations.NotNull;

public final class ByteParser
implements Parser<byte[]> {
    public static final ByteParser INSTANCE = new ByteParser();

    private ByteParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<byte[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        MutableObject<Source<byte[]>> sourceHolder = new MutableObject<Source<byte[]>>();
        Sink<byte[]> sink = gctx.sinkFactory().forByte(gctx.colNum(), sourceHolder);
        return new Parser.ParserContext<byte[]>(sink, sourceHolder.getValue(), DataType.BYTE, new byte[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<byte[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableLong longHolder = new MutableLong();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<byte[]> sink = pctx.sink();
        Byte reservedValue = gctx.sinkFactory().reservedByte();
        byte[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            long value;
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseLong(ih.bs(), longHolder) || !RangeTests.isInRangeForByte(value = longHolder.longValue()) || reservedValue != null && value == (long)reservedValue.byteValue()) break;
            if (ih.bs().size() != 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = (byte)value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

