/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableInt;
import org.jetbrains.annotations.NotNull;

public final class CharParser
implements Parser<char[]> {
    public static final CharParser INSTANCE = new CharParser();

    private CharParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<char[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<char[]> sink = gctx.sinkFactory().forChar(gctx.colNum());
        return new Parser.ParserContext<char[]>(sink, null, DataType.CHAR, new char[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<char[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableInt intHolder = new MutableInt();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<char[]> sink = pctx.sink();
        Character reservedValue = gctx.sinkFactory().reservedChar();
        char[] values = pctx.valueChunk();
        if (!gctx.isNullOrWidthOneSoFar()) {
            return begin;
        }
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseBMPChar(ih.bs(), intHolder)) {
                gctx.clearIsNullOrWidthOneSoFar();
                break;
            }
            char value = (char)intHolder.intValue();
            if (reservedValue != null && value == reservedValue.charValue()) break;
            values[chunkIndex] = value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

