/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableLong;
import org.jetbrains.annotations.NotNull;

public final class DateTimeAsLongParser
implements Parser<long[]> {
    public static final DateTimeAsLongParser INSTANCE = new DateTimeAsLongParser();

    private DateTimeAsLongParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<long[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<long[]> sink = gctx.sinkFactory().forDateTimeAsLong(gctx.colNum());
        return new Parser.ParserContext<long[]>(sink, null, DataType.DATETIME_AS_LONG, new long[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<long[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableLong dateTimeAsLongHolder = new MutableLong();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<long[]> sink = pctx.sink();
        Long reservedValue = gctx.sinkFactory().reservedDateTimeAsLong();
        long[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseDateTime(ih.bs(), dateTimeAsLongHolder)) break;
            long value = dateTimeAsLongHolder.longValue();
            if (reservedValue != null && value == reservedValue) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

