/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactory;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public interface Parser<TARRAY> {
    public static final int CHUNK_SIZE = 262144;

    @NotNull
    public ParserContext<TARRAY> makeParserContext(GlobalContext var1, int var2);

    public long tryParse(GlobalContext var1, ParserContext<TARRAY> var2, IteratorHolder var3, long var4, long var6, boolean var8) throws CsvReaderException;

    public static class ParserContext<TARRAY> {
        private final Sink<TARRAY> sink;
        private final Source<TARRAY> source;
        private final DataType dataType;
        private final TARRAY valueChunk;

        public ParserContext(Sink<TARRAY> sink, Source<TARRAY> source, DataType dataType, TARRAY valueChunk) {
            this.sink = sink;
            this.source = source;
            this.dataType = dataType;
            this.valueChunk = valueChunk;
        }

        public Sink<TARRAY> sink() {
            return this.sink;
        }

        public Source<TARRAY> source() {
            return this.source;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public TARRAY valueChunk() {
            return this.valueChunk;
        }
    }

    public static class GlobalContext {
        private final int colNum;
        private final Tokenizer tokenizer;
        private final SinkFactory sinkFactory;
        private boolean isNullOrWidthOneSoFar;
        private final byte[][] nullSentinelsAsBytes;
        private final boolean[] nullChunk;

        public GlobalContext(int colNum, Tokenizer tokenizer, SinkFactory sinkFactory, String[] nullValueLiterals) {
            this.colNum = colNum;
            this.tokenizer = tokenizer;
            this.sinkFactory = sinkFactory;
            this.isNullOrWidthOneSoFar = true;
            this.nullSentinelsAsBytes = new byte[nullValueLiterals.length][];
            for (int ii = 0; ii < nullValueLiterals.length; ++ii) {
                this.nullSentinelsAsBytes[ii] = nullValueLiterals[ii].getBytes(StandardCharsets.UTF_8);
            }
            this.nullChunk = new boolean[262144];
        }

        public boolean isNullCell(IteratorHolder ih) {
            for (byte[] nullSentinel : this.nullSentinelsAsBytes) {
                if (!GlobalContext.equals(ih.bs().data(), ih.bs().begin(), ih.bs().end(), nullSentinel, 0, nullSentinel.length)) continue;
                return true;
            }
            return false;
        }

        public int colNum() {
            return this.colNum;
        }

        public Tokenizer tokenizer() {
            return this.tokenizer;
        }

        public SinkFactory sinkFactory() {
            return this.sinkFactory;
        }

        public boolean isNullOrWidthOneSoFar() {
            return this.isNullOrWidthOneSoFar;
        }

        public void clearIsNullOrWidthOneSoFar() {
            this.isNullOrWidthOneSoFar = false;
        }

        public byte[][] nullSentinelsAsBytes() {
            return this.nullSentinelsAsBytes;
        }

        public boolean[] nullChunk() {
            return this.nullChunk;
        }

        private static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
            int aLength = aToIndex - aFromIndex;
            int bLength = bToIndex - bFromIndex;
            if (aLength != bLength) {
                return false;
            }
            for (int i = 0; i < aLength; ++i) {
                if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
                return false;
            }
            return true;
        }
    }
}

