/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.ArraySourceAndSinkBase;

final class ArrayIntSink
extends ArraySourceAndSinkBase<int[]> {
    private final Integer nullSentinel;

    public ArrayIntSink(Integer nullSentinel) {
        super(int[]::new, nullSentinel != null);
        this.nullSentinel = nullSentinel;
    }

    @Override
    protected void nullFlagsToValues(boolean[] isNull, int[] values, int size) {
        for (int ii = 0; ii < size; ++ii) {
            if (!isNull[ii]) continue;
            values[ii] = this.nullSentinel;
        }
    }

    @Override
    protected void nullValuesToFlags(int[] values, boolean[] isNull, int size) {
        for (int ii = 0; ii < size; ++ii) {
            isNull[ii] = values[ii] == this.nullSentinel;
        }
    }
}

