/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.ArraySourceAndSinkBase;

final class ArrayShortSink
extends ArraySourceAndSinkBase<short[]> {
    private final Short nullSentinel;

    public ArrayShortSink(Short nullSentinel) {
        super(short[]::new, nullSentinel != null);
        this.nullSentinel = nullSentinel;
    }

    @Override
    protected void nullFlagsToValues(boolean[] isNull, short[] values, int size) {
        for (int ii = 0; ii < size; ++ii) {
            if (!isNull[ii]) continue;
            values[ii] = this.nullSentinel;
        }
    }

    @Override
    protected void nullValuesToFlags(short[] values, boolean[] isNull, int size) {
        for (int ii = 0; ii < size; ++ii) {
            isNull[ii] = values[ii] == this.nullSentinel;
        }
    }
}

