/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.util;

import java.util.function.Function;

public class Renderer {
    public static <T> String renderList(Iterable<T> items) {
        return Renderer.renderList(items, ", ", Object::toString);
    }

    public static <T> String renderList(Iterable<T> items, String separator) {
        return Renderer.renderList(items, separator, Object::toString);
    }

    public static <T> String renderList(Iterable<T> items, String separator, Function<T, String> renderer) {
        return Renderer.renderList(new StringBuilder(), items, separator, renderer).toString();
    }

    public static <T> StringBuilder renderList(StringBuilder sb, Iterable<T> items, String separator, Function<T, String> renderer) {
        String separatorToUse = "";
        for (T item : items) {
            sb.append(separatorToUse);
            sb.append(renderer.apply(item));
            separatorToUse = separator;
        }
        return sb;
    }
}

