/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.containers;

import org.jetbrains.annotations.NotNull;

public final class ByteSlice
implements CharSequence {
    private byte[] data;
    private int begin;
    private int end;

    public ByteSlice() {
    }

    public ByteSlice(byte[] data, int begin, int end) {
        this.reset(data, begin, end);
    }

    public void reset(byte[] data, int begin, int end) {
        this.data = data;
        this.begin = begin;
        this.end = end;
    }

    public void copyTo(byte[] dest, int destOffset) {
        System.arraycopy(this.data, this.begin, dest, destOffset, this.end - this.begin);
    }

    public int begin() {
        return this.begin;
    }

    public int end() {
        return this.end;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public byte front() {
        return this.data[this.begin];
    }

    public byte back() {
        return this.data[this.end - 1];
    }

    public byte[] data() {
        return this.data;
    }

    public int size() {
        return this.end - this.begin;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public char charAt(int i) {
        int index = this.begin + i;
        if (index < this.begin || index >= this.end) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        return (char)this.data[index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        int newBegin = this.begin + start;
        int newEnd = this.begin + end;
        if (newBegin < this.begin || newEnd > this.end || newBegin > newEnd) {
            throw new IndexOutOfBoundsException("Invalid subsequence bounds");
        }
        return new ByteSlice(this.data, newBegin, newEnd);
    }

    @Override
    @NotNull
    public String toString() {
        int size = this.size();
        return size == 0 ? "" : new String(this.data, this.begin, size);
    }
}

