/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.densestorage;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.QueueReader;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableInt;

public final class DenseStorageReader {
    private final QueueReader.IntReader controlReader;
    private final QueueReader.ByteReader byteReader;
    private final QueueReader.ByteArrayReader largeByteArrayReader;
    private final MutableInt intHolder;

    public DenseStorageReader(QueueReader.IntReader controlReader, QueueReader.ByteReader byteReader, QueueReader.ByteArrayReader largeByteArrayReader) {
        this.controlReader = controlReader;
        this.byteReader = byteReader;
        this.largeByteArrayReader = largeByteArrayReader;
        this.intHolder = new MutableInt();
    }

    public DenseStorageReader copy() {
        return new DenseStorageReader(this.controlReader.copy(), this.byteReader.copy(), this.largeByteArrayReader.copy());
    }

    public boolean tryGetNextSlice(ByteSlice bs) throws CsvReaderException {
        if (!this.controlReader.tryGetInt(this.intHolder)) {
            return false;
        }
        int control = this.intHolder.intValue();
        if (control == -1) {
            DenseStorageReader.mustSucceed(this.largeByteArrayReader.tryGetBytes(bs), "largeByteArrayReader");
            return true;
        }
        DenseStorageReader.mustSucceed(this.byteReader.tryGetBytes(control, bs), "byteReader");
        return true;
    }

    private static void mustSucceed(boolean success, String what) throws CsvReaderException {
        if (!success) {
            throw new CsvReaderException("Data unexpectedly exhausted: " + what);
        }
    }
}

