/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableLong;
import org.jetbrains.annotations.NotNull;

public abstract class TimestampParserBase
implements Parser<long[]> {
    protected static final long SECOND_SCALE = 1000000000L;
    protected static final long MILLISECOND_SCALE = 1000000L;
    protected static final long MICROSECOND_SCALE = 1000L;
    protected static final long NANOSECOND_SCALE = 1L;
    private final long scale;
    private final long minValue;
    private final long maxValue;

    protected TimestampParserBase(long scale) {
        this.scale = scale;
        this.minValue = Long.MIN_VALUE / scale;
        this.maxValue = Long.MAX_VALUE / scale;
    }

    @Override
    @NotNull
    public Parser.ParserContext<long[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<long[]> sink = gctx.sinkFactory().forTimestampAsLong(gctx.colNum());
        return new Parser.ParserContext<long[]>(sink, null, DataType.TIMESTAMP_AS_LONG, new long[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<long[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableLong longHolder = new MutableLong();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<long[]> sink = pctx.sink();
        Long reservedValue = gctx.sinkFactory().reservedTimestampAsLong();
        long[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            long value;
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseLong(ih.bs(), longHolder) || (value = longHolder.longValue()) < this.minValue || value > this.maxValue || reservedValue != null && value == reservedValue) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = value * this.scale;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

