/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.DenseStorageWriter;
import io.deephaven.csv.reading.CellGrabber;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableBoolean;
import java.nio.charset.StandardCharsets;

public class ParseInputToDenseStorage {
    public static long doit(String[] columnHeaders, byte[][] optionalFirstDataRow, CellGrabber grabber, CsvSpecs specs, String[][] nullValueLiteralsToUse, DenseStorageWriter[] dsws) throws CsvReaderException {
        RowResult result;
        RowResult result2;
        long numProcessedRows = 0L;
        RowAppender rowAppender = new RowAppender(columnHeaders, optionalFirstDataRow, grabber, specs, nullValueLiteralsToUse, dsws);
        for (long skipRows = specs.skipRows(); skipRows != 0L && (result2 = rowAppender.processNextRow(false)) != RowResult.END_OF_INPUT; --skipRows) {
        }
        for (long numRows = specs.numRows(); numRows != 0L && (result = rowAppender.processNextRow(true)) != RowResult.END_OF_INPUT; --numRows) {
            if (result != RowResult.PROCESSED_ROW) continue;
            ++numProcessedRows;
        }
        for (DenseStorageWriter dsw : dsws) {
            if (dsw == null) continue;
            dsw.finish();
        }
        return numProcessedRows;
    }

    private static void appendToDenseStorageWriter(DenseStorageWriter dsw, ByteSlice bs, boolean writeToConsumer) throws CsvReaderException {
        if (!writeToConsumer) {
            return;
        }
        if (dsw != null) {
            dsw.append(bs);
            return;
        }
        if (bs.size() != 0) {
            throw new CsvReaderException("Column assumed empty but contains data");
        }
    }

    private static String describeColumnHeader(String[] columnHeaders, int colNum) {
        if (colNum < columnHeaders.length) {
            return '\"' + columnHeaders[colNum] + '\"';
        }
        return String.format("(Column %d)", colNum);
    }

    private static class RowAppender {
        private final String[] columnHeaders;
        private byte[][] optionalFirstDataRow;
        private final CellGrabber grabber;
        private final DenseStorageWriter[] dsws;
        private final CsvSpecs specs;
        private final int numCols;
        private final ByteSlice byteSlice;
        private final MutableBoolean lastInRow;
        private final MutableBoolean endOfInput;
        private final byte[][] nullValueLiteralsAsUtf8;

        public RowAppender(String[] columnHeaders, byte[][] optionalFirstDataRow, CellGrabber grabber, CsvSpecs specs, String[][] nullValueLiteralsToUse, DenseStorageWriter[] dsws) throws CsvReaderException {
            this.columnHeaders = columnHeaders;
            this.optionalFirstDataRow = optionalFirstDataRow;
            this.grabber = grabber;
            this.dsws = dsws;
            this.specs = specs;
            this.numCols = dsws.length;
            if (optionalFirstDataRow != null && optionalFirstDataRow.length != this.numCols) {
                throw new CsvReaderException(String.format("Expected %d columns but optionalFirstRow had %d", this.numCols, optionalFirstDataRow.length));
            }
            this.byteSlice = new ByteSlice();
            this.lastInRow = new MutableBoolean();
            this.endOfInput = new MutableBoolean();
            this.nullValueLiteralsAsUtf8 = new byte[nullValueLiteralsToUse.length][];
            for (int ii = 0; ii < nullValueLiteralsToUse.length; ++ii) {
                String[] nvls = nullValueLiteralsToUse[ii];
                if (nvls.length == 0) continue;
                this.nullValueLiteralsAsUtf8[ii] = nvls[0].getBytes(StandardCharsets.UTF_8);
            }
        }

        public RowResult processNextRow(boolean writeToConsumer) throws CsvReaderException {
            if (this.optionalFirstDataRow != null) {
                for (int ii = 0; ii < this.numCols; ++ii) {
                    byte[] temp = this.optionalFirstDataRow[ii];
                    this.byteSlice.reset(temp, 0, temp.length);
                    ParseInputToDenseStorage.appendToDenseStorageWriter(this.dsws[ii], this.byteSlice, writeToConsumer);
                }
                this.optionalFirstDataRow = null;
                return RowResult.PROCESSED_ROW;
            }
            int physicalRowNum = this.grabber.physicalRowNum();
            int colNum = 0;
            for (colNum = 0; colNum < this.numCols; ++colNum) {
                try {
                    this.grabber.grabNext(this.byteSlice, this.lastInRow, this.endOfInput);
                    if (this.lastInRow.booleanValue()) {
                        if (colNum == 0 && this.byteSlice.size() == 0) {
                            if (this.endOfInput.booleanValue()) {
                                return RowResult.END_OF_INPUT;
                            }
                            if (this.specs.ignoreEmptyLines()) {
                                return RowResult.IGNORED_EMPTY_ROW;
                            }
                        }
                        ParseInputToDenseStorage.appendToDenseStorageWriter(this.dsws[colNum], this.byteSlice, writeToConsumer);
                        ++colNum;
                        break;
                    }
                    ParseInputToDenseStorage.appendToDenseStorageWriter(this.dsws[colNum], this.byteSlice, writeToConsumer);
                    continue;
                }
                catch (Exception e) {
                    String message = String.format("While processing row %d, column %s:", physicalRowNum + 1, ParseInputToDenseStorage.describeColumnHeader(this.columnHeaders, colNum));
                    throw new CsvReaderException(message, e);
                }
            }
            if (!this.lastInRow.booleanValue()) {
                if (!this.specs.ignoreExcessColumns()) {
                    String message = String.format("Row %d has too many columns (expected %d)", physicalRowNum + 1, this.numCols);
                    throw new CsvReaderException(message);
                }
                while (!this.lastInRow.booleanValue()) {
                    this.grabber.grabNext(this.byteSlice, this.lastInRow, this.endOfInput);
                }
            }
            if (colNum >= this.numCols) {
                return RowResult.PROCESSED_ROW;
            }
            if (!this.specs.allowMissingColumns()) {
                String message = String.format("Row %d has too few columns (expected %d)", physicalRowNum + 1, this.numCols);
                throw new CsvReaderException(message);
            }
            while (colNum < this.numCols) {
                byte[] nvl = this.nullValueLiteralsAsUtf8[colNum];
                if (nvl == null) {
                    String message = String.format("Row %d is short, but can't null-fill it because there is no configured null value literal for column %s.", physicalRowNum + 1, ParseInputToDenseStorage.describeColumnHeader(this.columnHeaders, colNum));
                    throw new CsvReaderException(message);
                }
                this.byteSlice.reset(nvl, 0, nvl.length);
                ParseInputToDenseStorage.appendToDenseStorageWriter(this.dsws[colNum], this.byteSlice, writeToConsumer);
                ++colNum;
            }
            return RowResult.PROCESSED_ROW;
        }
    }

    private static enum RowResult {
        END_OF_INPUT,
        IGNORED_EMPTY_ROW,
        PROCESSED_ROW;

    }
}

