/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.ArrayBooleanAsByteSink;
import io.deephaven.csv.sinks.ArrayByteSink;
import io.deephaven.csv.sinks.ArrayCharSink;
import io.deephaven.csv.sinks.ArrayDateTimeAsLongSink;
import io.deephaven.csv.sinks.ArrayDoubleSink;
import io.deephaven.csv.sinks.ArrayFloatSink;
import io.deephaven.csv.sinks.ArrayIntSink;
import io.deephaven.csv.sinks.ArrayLongSink;
import io.deephaven.csv.sinks.ArrayShortSink;
import io.deephaven.csv.sinks.ArrayStringSink;
import io.deephaven.csv.sinks.ArrayTimestampAsLongSink;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactory;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.util.MutableObject;

public class ArraySinkFactory
implements SinkFactory {
    private final Byte byteSentinel;
    private final Short shortSentinel;
    private final Integer intSentinel;
    private final Long longSentinel;
    private final Float floatSentinel;
    private final Double doubleSentinel;
    private final Byte booleanAsByteSentinel;
    private final Character charSentinel;
    private final String stringSentinel;
    private final Long dateTimeAsLongSentinel;
    private final Long timestampAsLongSentinel;

    public ArraySinkFactory(Byte byteSentinel, Short shortSentinel, Integer intSentinel, Long longSentinel, Float floatSentinel, Double doubleSentinel, Byte booleanAsByteSentinel, Character charSentinel, String stringSentinel, Long dateTimeAsLongSentinel, Long timestampAsLongSentinel) {
        this.byteSentinel = byteSentinel;
        this.shortSentinel = shortSentinel;
        this.intSentinel = intSentinel;
        this.longSentinel = longSentinel;
        this.floatSentinel = floatSentinel;
        this.doubleSentinel = doubleSentinel;
        this.booleanAsByteSentinel = booleanAsByteSentinel;
        this.charSentinel = charSentinel;
        this.stringSentinel = stringSentinel;
        this.dateTimeAsLongSentinel = dateTimeAsLongSentinel;
        this.timestampAsLongSentinel = timestampAsLongSentinel;
    }

    @Override
    public Sink<byte[]> forByte(int colNum, MutableObject<Source<byte[]>> source) {
        ArrayByteSink result = new ArrayByteSink(this.byteSentinel);
        source.setValue(result);
        return result;
    }

    @Override
    public Byte reservedByte() {
        return this.byteSentinel;
    }

    @Override
    public Sink<short[]> forShort(int colNum, MutableObject<Source<short[]>> source) {
        ArrayShortSink result = new ArrayShortSink(this.shortSentinel);
        source.setValue(result);
        return result;
    }

    @Override
    public Short reservedShort() {
        return this.shortSentinel;
    }

    @Override
    public Sink<int[]> forInt(int colNum, MutableObject<Source<int[]>> source) {
        ArrayIntSink result = new ArrayIntSink(this.intSentinel);
        source.setValue(result);
        return result;
    }

    @Override
    public Integer reservedInt() {
        return this.intSentinel;
    }

    @Override
    public Sink<long[]> forLong(int colNum, MutableObject<Source<long[]>> source) {
        ArrayLongSink result = new ArrayLongSink(this.longSentinel);
        source.setValue(result);
        return result;
    }

    @Override
    public Long reservedLong() {
        return this.longSentinel;
    }

    @Override
    public Sink<float[]> forFloat(int colNum) {
        return new ArrayFloatSink(this.floatSentinel);
    }

    @Override
    public Float reservedFloat() {
        return this.floatSentinel;
    }

    @Override
    public Sink<double[]> forDouble(int colNum) {
        return new ArrayDoubleSink(this.doubleSentinel);
    }

    @Override
    public Double reservedDouble() {
        return this.doubleSentinel;
    }

    @Override
    public Sink<byte[]> forBooleanAsByte(int colNum) {
        return new ArrayBooleanAsByteSink(this.booleanAsByteSentinel);
    }

    @Override
    public Sink<char[]> forChar(int colNum) {
        return new ArrayCharSink(this.charSentinel);
    }

    @Override
    public Character reservedChar() {
        return this.charSentinel;
    }

    @Override
    public Sink<String[]> forString(int colNum) {
        return new ArrayStringSink(this.stringSentinel);
    }

    @Override
    public String reservedString() {
        return this.stringSentinel;
    }

    @Override
    public Sink<long[]> forDateTimeAsLong(int colNum) {
        return new ArrayDateTimeAsLongSink(this.dateTimeAsLongSentinel);
    }

    @Override
    public Long reservedDateTimeAsLong() {
        return this.dateTimeAsLongSentinel;
    }

    @Override
    public Sink<long[]> forTimestampAsLong(int colNum) {
        return new ArrayTimestampAsLongSink(this.timestampAsLongSentinel);
    }

    @Override
    public Long reservedTimestampAsLong() {
        return this.timestampAsLongSentinel;
    }
}

