/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.densestorage;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.DenseStorageReader;
import io.deephaven.csv.densestorage.QueueReader;
import io.deephaven.csv.densestorage.QueueWriter;
import io.deephaven.csv.util.Pair;

public final class DenseStorageWriter {
    private final QueueWriter.IntWriter controlWriter;
    private final QueueWriter.ByteWriter byteWriter;
    private final QueueWriter.ByteArrayWriter largeByteArrayWriter;

    public static Pair<DenseStorageWriter, DenseStorageReader> create(boolean concurrent) {
        Pair<QueueWriter.IntWriter, QueueReader.IntReader> control = QueueWriter.IntWriter.create(100000, concurrent);
        Pair<QueueWriter.ByteWriter, QueueReader.ByteReader> bytes = QueueWriter.ByteWriter.create(0x100000, concurrent);
        Pair<QueueWriter.ByteArrayWriter, QueueReader.ByteArrayReader> byteArrays = QueueWriter.ByteArrayWriter.create(100000, concurrent);
        DenseStorageWriter writer = new DenseStorageWriter((QueueWriter.IntWriter)control.first, (QueueWriter.ByteWriter)bytes.first, (QueueWriter.ByteArrayWriter)byteArrays.first);
        DenseStorageReader reader = new DenseStorageReader((QueueReader.IntReader)control.second, (QueueReader.ByteReader)bytes.second, (QueueReader.ByteArrayReader)byteArrays.second);
        return new Pair<DenseStorageWriter, DenseStorageReader>(writer, reader);
    }

    private DenseStorageWriter(QueueWriter.IntWriter controlWriter, QueueWriter.ByteWriter byteWriter, QueueWriter.ByteArrayWriter largeByteArrayWriter) {
        this.controlWriter = controlWriter;
        this.byteWriter = byteWriter;
        this.largeByteArrayWriter = largeByteArrayWriter;
    }

    public void append(ByteSlice bs) {
        boolean fctrl;
        boolean fdata;
        int size = bs.size();
        if (size >= 1024) {
            byte[] data = new byte[size];
            bs.copyTo(data, 0);
            fdata = this.largeByteArrayWriter.addByteArray(data);
            fctrl = this.controlWriter.addInt(-1);
        } else {
            fdata = this.byteWriter.addBytes(bs);
            fctrl = this.controlWriter.addInt(size);
        }
        if (fctrl) {
            this.byteWriter.flush();
            this.largeByteArrayWriter.flush();
        } else if (fdata) {
            this.controlWriter.flush();
        }
    }

    public void finish() {
        this.controlWriter.finish();
        this.byteWriter.finish();
        this.largeByteArrayWriter.finish();
    }
}

