/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.densestorage;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.QueueNode;
import io.deephaven.csv.util.MutableInt;

public class QueueReader<TARRAY> {
    private QueueNode<TARRAY> node;
    protected TARRAY genericBlock;
    protected int current;
    protected int end;

    protected QueueReader(QueueNode<TARRAY> node) {
        this.node = node;
        this.genericBlock = null;
        this.current = 0;
        this.end = 0;
    }

    protected QueueReader(QueueReader<TARRAY> other) {
        this.node = other.node;
        this.genericBlock = other.genericBlock;
        this.current = other.current;
        this.end = other.end;
    }

    protected boolean tryRefill(int size) {
        if (this.current != this.end) {
            throw new RuntimeException("Logic error: slice straddled block");
        }
        while (this.current == this.end) {
            if (this.node.isLast) {
                this.node = null;
                this.genericBlock = null;
                this.current = 0;
                this.end = 0;
                return false;
            }
            this.node = this.node.waitForNext();
            this.genericBlock = this.node.data;
            this.current = this.node.begin;
            this.end = this.node.end;
        }
        if (this.end - this.current < size) {
            throw new RuntimeException(String.format("Logic error: got short block: expected at least %d, got %d", size, this.end - this.current));
        }
        return true;
    }

    public static final class ByteArrayReader
    extends QueueReader<byte[][]> {
        private byte[][] typedBlock;

        public ByteArrayReader(QueueNode<byte[][]> head) {
            super(head);
        }

        private ByteArrayReader(ByteArrayReader other) {
            super(other);
            this.typedBlock = other.typedBlock;
        }

        public ByteArrayReader copy() {
            return new ByteArrayReader(this);
        }

        public boolean tryGetBytes(ByteSlice bs) {
            if (this.current == this.end) {
                if (!this.tryRefill(1)) {
                    return false;
                }
                this.typedBlock = (byte[][])this.genericBlock;
            }
            byte[] data = this.typedBlock[this.current++];
            bs.reset(data, 0, data.length);
            return true;
        }
    }

    public static final class IntReader
    extends QueueReader<int[]> {
        private int[] typedBlock;

        public IntReader(QueueNode<int[]> head) {
            super(head);
        }

        private IntReader(IntReader other) {
            super(other);
            this.typedBlock = other.typedBlock;
        }

        public IntReader copy() {
            return new IntReader(this);
        }

        public boolean tryGetInt(MutableInt result) {
            if (this.current == this.end) {
                if (!this.tryRefill(1)) {
                    return false;
                }
                this.typedBlock = (int[])this.genericBlock;
            }
            result.setValue(this.typedBlock[this.current++]);
            return true;
        }
    }

    public static final class ByteReader
    extends QueueReader<byte[]> {
        private byte[] typedBlock;

        public ByteReader(QueueNode<byte[]> head) {
            super(head);
        }

        private ByteReader(ByteReader other) {
            super(other);
            this.typedBlock = other.typedBlock;
        }

        public ByteReader copy() {
            return new ByteReader(this);
        }

        public boolean tryGetBytes(int size, ByteSlice bs) {
            if (this.current + size > this.end) {
                if (!this.tryRefill(size)) {
                    return false;
                }
                this.typedBlock = (byte[])this.genericBlock;
            }
            bs.reset(this.typedBlock, this.current, this.current + size);
            this.current += size;
            return true;
        }
    }
}

