/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableFloat;
import org.jetbrains.annotations.NotNull;

public final class FloatStrictParser
implements Parser<float[]> {
    public static final FloatStrictParser INSTANCE = new FloatStrictParser();

    private FloatStrictParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<float[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<float[]> sink = gctx.sinkFactory().forFloat(gctx.colNum());
        return new Parser.ParserContext<float[]>(sink, null, DataType.FLOAT, new float[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<float[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableFloat floatHolder = new MutableFloat();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<float[]> sink = pctx.sink();
        Float reservedValue = gctx.sinkFactory().reservedFloat();
        float[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseFloatStrict(ih.bs(), floatHolder)) break;
            float value = floatHolder.floatValue();
            if (reservedValue != null && value == reservedValue.floatValue()) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

