/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.MutableObject;
import org.jetbrains.annotations.NotNull;

public final class LongParser
implements Parser<long[]> {
    public static final LongParser INSTANCE = new LongParser();

    private LongParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<long[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        MutableObject<Source<long[]>> sourceHolder = new MutableObject<Source<long[]>>();
        Sink<long[]> sink = gctx.sinkFactory().forLong(gctx.colNum(), sourceHolder);
        return new Parser.ParserContext<long[]>(sink, sourceHolder.getValue(), DataType.LONG, new long[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<long[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableLong longHolder = new MutableLong();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<long[]> sink = pctx.sink();
        Long reservedValue = gctx.sinkFactory().reservedLong();
        long[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseLong(ih.bs(), longHolder)) break;
            long value = longHolder.longValue();
            if (reservedValue != null && value == reservedValue) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

