/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.BooleanAsByteParser;
import io.deephaven.csv.parsers.ByteParser;
import io.deephaven.csv.parsers.CharParser;
import io.deephaven.csv.parsers.DateTimeAsLongParser;
import io.deephaven.csv.parsers.DoubleParser;
import io.deephaven.csv.parsers.FloatFastParser;
import io.deephaven.csv.parsers.FloatStrictParser;
import io.deephaven.csv.parsers.IntParser;
import io.deephaven.csv.parsers.LongParser;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.parsers.ShortParser;
import io.deephaven.csv.parsers.StringParser;
import io.deephaven.csv.parsers.TimestampMicrosParser;
import io.deephaven.csv.parsers.TimestampMillisParser;
import io.deephaven.csv.parsers.TimestampNanosParser;
import io.deephaven.csv.parsers.TimestampSecondsParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Parsers {
    public static final Parser<?> BOOLEAN = BooleanAsByteParser.INSTANCE;
    public static final Parser<?> BYTE = ByteParser.INSTANCE;
    public static final Parser<?> SHORT = ShortParser.INSTANCE;
    public static final Parser<?> INT = IntParser.INSTANCE;
    public static final Parser<?> LONG = LongParser.INSTANCE;
    public static final Parser<?> FLOAT_FAST = FloatFastParser.INSTANCE;
    public static final Parser<?> FLOAT_STRICT = FloatStrictParser.INSTANCE;
    public static final Parser<?> DOUBLE = DoubleParser.INSTANCE;
    public static final Parser<?> DATETIME = DateTimeAsLongParser.INSTANCE;
    public static final Parser<?> CHAR = CharParser.INSTANCE;
    public static final Parser<?> STRING = StringParser.INSTANCE;
    public static final Parser<?> TIMESTAMP_SECONDS = TimestampSecondsParser.INSTANCE;
    public static final Parser<?> TIMESTAMP_MILLIS = TimestampMillisParser.INSTANCE;
    public static final Parser<?> TIMESTAMP_MICROS = TimestampMicrosParser.INSTANCE;
    public static final Parser<?> TIMESTAMP_NANOS = TimestampNanosParser.INSTANCE;
    public static final List<Parser<?>> DEFAULT = Parsers.unmodifiable(BOOLEAN, INT, LONG, DOUBLE, DATETIME, CHAR, STRING);
    public static final List<Parser<?>> COMPLETE = Parsers.unmodifiable(BOOLEAN, BYTE, SHORT, INT, LONG, DOUBLE, DATETIME, CHAR, STRING);
    public static final List<Parser<?>> COMPLETE_FLOAT = Parsers.unmodifiable(BOOLEAN, BYTE, SHORT, INT, LONG, FLOAT_FAST, DATETIME, CHAR, STRING);
    public static final List<Parser<?>> MINIMAL = Parsers.unmodifiable(BOOLEAN, LONG, DOUBLE, DATETIME, STRING);
    public static final List<Parser<?>> STRINGS = Collections.singletonList(STRING);
    public static final List<Parser<?>> STANDARD_TIMES = Parsers.someOtherParsersAnd(TIMESTAMP_SECONDS);
    public static final List<Parser<?>> STANDARD_MILLITIMES = Parsers.someOtherParsersAnd(TIMESTAMP_MILLIS);
    public static final List<Parser<?>> STANDARD_MICROTIMES = Parsers.someOtherParsersAnd(TIMESTAMP_MICROS);
    public static final List<Parser<?>> STANDARD_NANOTIMES = Parsers.someOtherParsersAnd(TIMESTAMP_NANOS);

    private static List<Parser<?>> unmodifiable(Parser<?> ... parsers) {
        return Collections.unmodifiableList(Arrays.asList(parsers));
    }

    private static List<Parser<?>> someOtherParsersAnd(Parser<?> oneMore) {
        ArrayList result = new ArrayList();
        result.add(BOOLEAN);
        result.add(DATETIME);
        result.add(CHAR);
        result.add(STRING);
        result.add(oneMore);
        return Collections.unmodifiableList(new ArrayList(result));
    }
}

