/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.util.MutableInt;

public class ReaderUtil {
    public static String[] makeSyntheticHeaders(int numHeaders) {
        String[] result = new String[numHeaders];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = "Column" + (ii + 1);
        }
        return result;
    }

    public static void trimSpacesAndTabs(ByteSlice cs) {
        int begin;
        byte[] data = cs.data();
        int end = cs.end();
        for (begin = cs.begin(); begin != end && RangeTests.isSpaceOrTab(data[begin]); ++begin) {
        }
        while (begin != end && RangeTests.isSpaceOrTab(data[end - 1])) {
            --end;
        }
        cs.reset(data, begin, end);
    }

    public static int getUtf8LengthAndCharLength(byte firstByte, int numBytes, boolean useUtf32CountingConvention, MutableInt charCountResult) {
        int utf8Length = ReaderUtil.getUtf8Length(firstByte);
        if (utf8Length > numBytes) {
            throw new RuntimeException(String.format("The next UTF-8 character needs %d bytes but there are only %d left in the field", utf8Length, numBytes));
        }
        int numChars = useUtf32CountingConvention || utf8Length < 4 ? 1 : 2;
        charCountResult.setValue(numChars);
        return utf8Length;
    }

    private static int getUtf8Length(byte firstByte) {
        if ((firstByte & 0x80) == 0) {
            return 1;
        }
        if ((firstByte & 0xE0) == 192) {
            return 2;
        }
        if ((firstByte & 0xF0) == 224) {
            return 3;
        }
        if ((firstByte & 0xF8) == 240) {
            return 4;
        }
        throw new IllegalStateException(String.format("0x%x is not a valid starting byte for a UTF-8 sequence", firstByte));
    }
}

