/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading;

import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.Source;
import java.lang.reflect.Array;

public class TypeConverter {
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;

    public static <TARRAY, UARRAY> void copy(Source<TARRAY> source, Sink<UARRAY> dest, long srcBegin, long srcEnd, long destBegin, TARRAY srcChunk, UARRAY destChunk, boolean[] isNull) {
        if (srcBegin == srcEnd) {
            return;
        }
        int srcChunkSize = Array.getLength(srcChunk);
        int destChunkSize = Array.getLength(destChunk);
        int isNullChunkSize = isNull.length;
        if (srcChunkSize != destChunkSize || srcChunkSize != isNullChunkSize) {
            String message = String.format("Logic error: chunk sizes differ: %d vs %d vs %d", srcChunkSize, destChunkSize, isNullChunkSize);
            throw new RuntimeException(message);
        }
        CopyOperation performCopy = TypeConverter.getChunkCopierFor(srcChunk.getClass(), destChunk.getClass());
        long srcCurrent = srcBegin;
        long destCurrent = destBegin;
        while (srcCurrent != srcEnd) {
            long srcEndToUse = Math.min(srcCurrent + (long)srcChunkSize, srcEnd);
            int copySize = Math.toIntExact(srcEndToUse - srcCurrent);
            long destEndToUse = destCurrent + (long)copySize;
            source.read(srcChunk, isNull, srcCurrent, srcEndToUse);
            performCopy.accept(srcChunk, destChunk, copySize);
            dest.write(destChunk, isNull, destCurrent, destEndToUse, false);
            srcCurrent = srcEndToUse;
            destCurrent = destEndToUse;
        }
    }

    private static <T, U> CopyOperation getChunkCopierFor(Class<T> srcClass, Class<U> destClass) {
        int srcType = TypeConverter.identify(srcClass);
        int sinkType = TypeConverter.identify(destClass);
        switch (srcType * 100 + sinkType) {
            case 102: {
                return TypeConverter::copyByteToShort;
            }
            case 103: {
                return TypeConverter::copyByteToInt;
            }
            case 104: {
                return TypeConverter::copyByteToLong;
            }
            case 105: {
                return TypeConverter::copyByteToFloat;
            }
            case 106: {
                return TypeConverter::copyByteToDouble;
            }
            case 203: {
                return TypeConverter::copyShortToInt;
            }
            case 204: {
                return TypeConverter::copyShortToLong;
            }
            case 205: {
                return TypeConverter::copyShortToFloat;
            }
            case 206: {
                return TypeConverter::copyShortToDouble;
            }
            case 304: {
                return TypeConverter::copyIntToLong;
            }
            case 305: {
                return TypeConverter::copyIntToFloat;
            }
            case 306: {
                return TypeConverter::copyIntToDouble;
            }
            case 405: {
                return TypeConverter::copyLongToFloat;
            }
            case 406: {
                return TypeConverter::copyLongToDouble;
            }
        }
        String message = String.format("Logic error: don't have a converter from %s to %s", srcClass.getCanonicalName(), destClass.getCanonicalName());
        throw new RuntimeException(message);
    }

    private static <T> int identify(Class<T> chunkClass) {
        if (chunkClass == byte[].class) {
            return 1;
        }
        if (chunkClass == short[].class) {
            return 2;
        }
        if (chunkClass == int[].class) {
            return 3;
        }
        if (chunkClass == long[].class) {
            return 4;
        }
        if (chunkClass == float[].class) {
            return 5;
        }
        if (chunkClass == double[].class) {
            return 6;
        }
        throw new RuntimeException("Unsupported chunk type " + chunkClass.getCanonicalName());
    }

    private static void copyByteToShort(Object src, Object dest, int size) {
        byte[] srcTyped = (byte[])src;
        short[] destTyped = (short[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyByteToInt(Object src, Object dest, int size) {
        byte[] srcTyped = (byte[])src;
        int[] destTyped = (int[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyByteToLong(Object src, Object dest, int size) {
        byte[] srcTyped = (byte[])src;
        long[] destTyped = (long[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyByteToFloat(Object src, Object dest, int size) {
        byte[] srcTyped = (byte[])src;
        float[] destTyped = (float[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyByteToDouble(Object src, Object dest, int size) {
        byte[] srcTyped = (byte[])src;
        double[] destTyped = (double[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyShortToInt(Object src, Object dest, int size) {
        short[] srcTyped = (short[])src;
        int[] destTyped = (int[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyShortToLong(Object src, Object dest, int size) {
        short[] srcTyped = (short[])src;
        long[] destTyped = (long[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyShortToFloat(Object src, Object dest, int size) {
        short[] srcTyped = (short[])src;
        float[] destTyped = (float[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyShortToDouble(Object src, Object dest, int size) {
        short[] srcTyped = (short[])src;
        double[] destTyped = (double[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyIntToLong(Object src, Object dest, int size) {
        int[] srcTyped = (int[])src;
        long[] destTyped = (long[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyIntToFloat(Object src, Object dest, int size) {
        int[] srcTyped = (int[])src;
        float[] destTyped = (float[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyIntToDouble(Object src, Object dest, int size) {
        int[] srcTyped = (int[])src;
        double[] destTyped = (double[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyLongToFloat(Object src, Object dest, int size) {
        long[] srcTyped = (long[])src;
        float[] destTyped = (float[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static void copyLongToDouble(Object src, Object dest, int size) {
        long[] srcTyped = (long[])src;
        double[] destTyped = (double[])dest;
        for (int ii = 0; ii < size; ++ii) {
            destTyped[ii] = srcTyped[ii];
        }
    }

    private static interface CopyOperation {
        public void accept(Object var1, Object var2, int var3);
    }
}

