/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading.cells;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.reading.ReaderUtil;
import io.deephaven.csv.reading.cells.CellGrabber;
import io.deephaven.csv.reading.cells.DelimitedCellGrabber;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableBoolean;
import io.deephaven.csv.util.MutableInt;
import java.io.InputStream;

public class FixedCellGrabber
implements CellGrabber {
    private final CellGrabber lineGrabber;
    private final int[] columnWidths;
    private final boolean ignoreSurroundingSpaces;
    private final boolean utf32CountingMode;
    private final ByteSlice rowText;
    private boolean needsUnderlyingRefresh;
    private int colIndex;
    private final MutableBoolean dummy1;
    private final MutableInt dummy2;

    public static CellGrabber makeLineGrabber(InputStream stream) {
        int IllegalUtf8 = -1;
        return new DelimitedCellGrabber(stream, -1, -1, true, false);
    }

    public FixedCellGrabber(CellGrabber lineGrabber, int[] columnWidths, boolean ignoreSurroundingSpaces, boolean utf32CountingMode) {
        this.lineGrabber = lineGrabber;
        this.columnWidths = columnWidths;
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.utf32CountingMode = utf32CountingMode;
        this.rowText = new ByteSlice();
        this.needsUnderlyingRefresh = true;
        this.colIndex = 0;
        this.dummy1 = new MutableBoolean();
        this.dummy2 = new MutableInt();
    }

    @Override
    public void grabNext(ByteSlice dest, MutableBoolean lastInRow, MutableBoolean endOfInput) throws CsvReaderException {
        if (this.needsUnderlyingRefresh) {
            this.lineGrabber.grabNext(this.rowText, this.dummy1, endOfInput);
            if (endOfInput.booleanValue()) {
                dest.reset(this.rowText.data(), this.rowText.end(), this.rowText.end());
                return;
            }
            this.needsUnderlyingRefresh = false;
            this.colIndex = 0;
        }
        boolean lastCol = this.colIndex == this.columnWidths.length - 1;
        int numCharsToTake = lastCol ? Integer.MAX_VALUE : this.columnWidths[this.colIndex];
        FixedCellGrabber.takeNCharactersInCharset(this.rowText, dest, numCharsToTake, this.utf32CountingMode, this.dummy2);
        ++this.colIndex;
        this.needsUnderlyingRefresh = lastCol || dest.size() == 0;
        lastInRow.setValue(this.needsUnderlyingRefresh);
        endOfInput.setValue(false);
        if (this.ignoreSurroundingSpaces) {
            ReaderUtil.trimSpacesAndTabs(dest);
        }
    }

    private static void takeNCharactersInCharset(ByteSlice src, ByteSlice dest, int numCharsToTake, boolean utf32CountingMode, MutableInt tempInt) {
        int cellBegin;
        int current;
        int utf8Length;
        byte[] data = src.data();
        for (current = cellBegin = src.begin(); numCharsToTake > 0 && current != src.end(); numCharsToTake -= tempInt.intValue(), current += utf8Length) {
            utf8Length = ReaderUtil.getUtf8LengthAndCharLength(data[current], src.end() - current, utf32CountingMode, tempInt);
            if (numCharsToTake < tempInt.intValue()) break;
        }
        dest.reset(src.data(), cellBegin, current);
        src.reset(src.data(), current, src.end());
    }

    @Override
    public int physicalRowNum() {
        return this.lineGrabber.physicalRowNum();
    }
}

