/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading.headers;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.reading.ReaderUtil;
import io.deephaven.csv.reading.cells.CellGrabber;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableBoolean;
import io.deephaven.csv.util.MutableObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class DelimitedHeaderFinder {
    public static String[] determineHeadersToUse(CsvSpecs specs, CellGrabber grabber, MutableObject<byte[][]> firstDataRowHolder) throws CsvReaderException {
        byte[][] firstDataRow;
        String[] headersToUse = null;
        if (specs.hasHeaderRow()) {
            byte[][] headerRow;
            long skipCount = specs.skipHeaderRows();
            while (true) {
                if ((headerRow = DelimitedHeaderFinder.tryReadOneRow(grabber)) == null) {
                    throw new CsvReaderException("Can't proceed because hasHeaderRow is set but input file is empty or shorter than skipHeaderRows");
                }
                if (skipCount == 0L) break;
                --skipCount;
            }
            headersToUse = (String[])Arrays.stream(headerRow).map(String::new).toArray(String[]::new);
        }
        if (specs.headers().size() != 0) {
            headersToUse = specs.headers().toArray(new String[0]);
        }
        if (headersToUse == null) {
            firstDataRow = DelimitedHeaderFinder.tryReadOneRow(grabber);
            if (firstDataRow == null) {
                throw new CsvReaderException("Can't proceed because input file is empty and client has not specified headers");
            }
            headersToUse = ReaderUtil.makeSyntheticHeaders(firstDataRow.length);
        } else {
            firstDataRow = null;
        }
        for (Map.Entry<Integer, String> entry : specs.headerForIndex().entrySet()) {
            headersToUse[entry.getKey().intValue()] = entry.getValue();
        }
        firstDataRowHolder.setValue(firstDataRow);
        return headersToUse;
    }

    private static byte[][] tryReadOneRow(CellGrabber grabber) throws CsvReaderException {
        ArrayList<byte[]> headers = new ArrayList<byte[]>();
        ByteSlice slice = new ByteSlice();
        MutableBoolean lastInRow = new MutableBoolean();
        MutableBoolean endOfInput = new MutableBoolean();
        do {
            grabber.grabNext(slice, lastInRow, endOfInput);
            byte[] item = new byte[slice.size()];
            slice.copyTo(item, 0);
            headers.add(item);
        } while (!lastInRow.booleanValue());
        if (headers.size() == 1 && ((byte[])headers.get(0)).length == 0 && endOfInput.booleanValue()) {
            return null;
        }
        return (byte[][])headers.toArray((T[])new byte[0][]);
    }
}

