/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading.headers;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.reading.ReaderUtil;
import io.deephaven.csv.reading.cells.CellGrabber;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableBoolean;
import io.deephaven.csv.util.MutableInt;
import io.deephaven.csv.util.MutableObject;
import java.util.ArrayList;
import java.util.Map;

public class FixedHeaderFinder {
    public static String[] determineHeadersToUse(CsvSpecs specs, CellGrabber lineGrabber, MutableObject<int[]> columnWidthsResult) throws CsvReaderException {
        String[] headersToUse;
        int[] columnWidthsToUse = specs.fixedColumnWidths().stream().mapToInt(Integer::intValue).toArray();
        if (specs.hasHeaderRow()) {
            long skipCount = specs.skipHeaderRows();
            ByteSlice headerRow = new ByteSlice();
            MutableBoolean lastInRow = new MutableBoolean();
            MutableBoolean endOfInput = new MutableBoolean();
            while (true) {
                lineGrabber.grabNext(headerRow, lastInRow, endOfInput);
                if (endOfInput.booleanValue()) {
                    throw new CsvReaderException("Can't proceed because hasHeaderRow is set but input file is empty or shorter than skipHeaderRows");
                }
                if (skipCount == 0L) break;
                --skipCount;
            }
            if (columnWidthsToUse.length == 0) {
                columnWidthsToUse = FixedHeaderFinder.inferColumnWidths(headerRow, specs.useUtf32CountingConvention());
            }
            headersToUse = FixedHeaderFinder.extractHeaders(headerRow, columnWidthsToUse, specs.useUtf32CountingConvention());
        } else {
            if (columnWidthsToUse.length == 0) {
                throw new CsvReaderException("Can't proceed because hasHeaderRow is false but fixedColumnWidths is unspecified");
            }
            headersToUse = ReaderUtil.makeSyntheticHeaders(columnWidthsToUse.length);
        }
        if (specs.headers().size() != 0) {
            if (specs.headers().size() != headersToUse.length) {
                String message = String.format("Library determined %d headers; caller overrode with %d headers", headersToUse.length, specs.headers().size());
                throw new CsvReaderException(message);
            }
            headersToUse = specs.headers().toArray(new String[0]);
        }
        for (Map.Entry<Integer, String> entry : specs.headerForIndex().entrySet()) {
            headersToUse[entry.getKey().intValue()] = entry.getValue();
        }
        columnWidthsResult.setValue(columnWidthsToUse);
        return headersToUse;
    }

    private static int[] inferColumnWidths(ByteSlice row, boolean useUtf32CountingConvention) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        MutableInt charCountResult = new MutableInt();
        boolean prevCharIsSpace = false;
        byte[] data = row.data();
        int numChars = 0;
        int currentIndex = row.begin();
        while (true) {
            boolean thisCharIsSpace;
            if (currentIndex == row.end()) {
                columnWidths.add(numChars);
                return columnWidths.stream().mapToInt(Integer::intValue).toArray();
            }
            byte ch = data[currentIndex];
            boolean bl = thisCharIsSpace = ch == 32;
            if (currentIndex == row.begin() && thisCharIsSpace) {
                throw new IllegalArgumentException("Header row cannot start with a space");
            }
            if (!thisCharIsSpace && prevCharIsSpace) {
                columnWidths.add(numChars);
                numChars = 0;
            }
            prevCharIsSpace = thisCharIsSpace;
            int utf8Length = ReaderUtil.getUtf8LengthAndCharLength(ch, row.end() - currentIndex, useUtf32CountingConvention, charCountResult);
            currentIndex += utf8Length;
            numChars += charCountResult.intValue();
        }
    }

    private static String[] extractHeaders(ByteSlice row, int[] columnWidths, boolean utf32CountingMode) {
        int numCols = columnWidths.length;
        if (numCols == 0) {
            return new String[0];
        }
        int[] byteWidths = new int[numCols];
        ByteSlice tempSlice = new ByteSlice();
        int excessBytes = FixedHeaderFinder.charWidthsToByteWidths(row, columnWidths, utf32CountingMode, byteWidths);
        int n = numCols - 1;
        byteWidths[n] = byteWidths[n] + excessBytes;
        String[] result = new String[numCols];
        int beginByte = row.begin();
        for (int colNum = 0; colNum != numCols; ++colNum) {
            int proposedEndByte = beginByte + byteWidths[colNum];
            int actualEndByte = Math.min(proposedEndByte, row.end());
            tempSlice.reset(row.data(), beginByte, actualEndByte);
            ReaderUtil.trimSpacesAndTabs(tempSlice);
            result[colNum] = tempSlice.toString();
            beginByte = actualEndByte;
        }
        return result;
    }

    private static int charWidthsToByteWidths(ByteSlice row, int[] charWidths, boolean utf32CountingMode, int[] byteWidths) {
        int start;
        int numCols = charWidths.length;
        if (byteWidths.length != numCols) {
            throw new IllegalArgumentException(String.format("Expected charWidths.length (%d) == byteWidths.length (%d)", charWidths.length, byteWidths.length));
        }
        MutableInt charCountResult = new MutableInt();
        byte[] data = row.data();
        int current = start = row.begin();
        int colIndex = 0;
        int charCount = 0;
        while (colIndex != numCols) {
            if (charCount == charWidths[colIndex]) {
                byteWidths[colIndex] = current - start;
                start = current;
                charCount = 0;
                ++colIndex;
                continue;
            }
            byte ch = data[current];
            int utf8Length = ReaderUtil.getUtf8LengthAndCharLength(ch, row.end() - current, utf32CountingMode, charCountResult);
            current += utf8Length;
            charCount += charCountResult.intValue();
        }
        return row.end() - current;
    }
}

