/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.ArraySinkBase;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.Source;
import java.util.function.IntFunction;

abstract class ArraySourceAndSinkBase<TARRAY>
extends ArraySinkBase<TARRAY>
implements Source<TARRAY>,
Sink<TARRAY> {
    protected ArraySourceAndSinkBase(IntFunction<TARRAY> arrayFactory, boolean hasNullSentinel) {
        super(arrayFactory, hasNullSentinel);
    }

    @Override
    public void read(TARRAY dest, boolean[] isNull, long srcBegin, long srcEnd) {
        if (srcBegin == srcEnd) {
            return;
        }
        int srcBeginAsInt = Math.toIntExact(srcBegin);
        int srcSize = Math.toIntExact(srcEnd - srcBegin);
        System.arraycopy(this.array, srcBeginAsInt, dest, 0, srcSize);
        if (this.hasNullSentinel) {
            this.nullValuesToFlags(dest, isNull, srcSize);
        }
    }

    protected abstract void nullValuesToFlags(TARRAY var1, boolean[] var2, int var3);
}

