/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactory;
import java.util.function.IntFunction;

abstract class SinkFactoryImplBase<TFLOATSINK extends Sink<float[]>, TDOUBLESINK extends Sink<double[]>, TBOOLASBYTESINK extends Sink<byte[]>, TCHARSINK extends Sink<char[]>, TSTRINGSINK extends Sink<String[]>, TDATETIMEASLONGSINK extends Sink<long[]>, TTIMESTAMPASLONGSINK extends Sink<long[]>>
implements SinkFactory {
    private final Byte reservedByte;
    private final Short reservedShort;
    private final Integer reservedInt;
    private final Long reservedLong;
    private final IntFunction<TFLOATSINK> floatSinkSupplier;
    private final Float reservedFloat;
    private final IntFunction<TDOUBLESINK> doubleSinkSupplier;
    private final Double reservedDouble;
    private final IntFunction<TBOOLASBYTESINK> booleanAsByteSinkSupplier;
    private final IntFunction<TCHARSINK> charSinkSupplier;
    private final Character reservedChar;
    private final IntFunction<TSTRINGSINK> stringSinkSupplier;
    private final String reservedString;
    private final IntFunction<TDATETIMEASLONGSINK> dateTimeAsLongSinkSupplier;
    private final Long reservedDateTimeAsLong;
    private final IntFunction<TTIMESTAMPASLONGSINK> timestampAsLongSinkSupplier;
    private final Long reservedTimestampAsLong;

    protected SinkFactoryImplBase(Byte reservedByte, Short reservedShort, Integer reservedInt, Long reservedLong, IntFunction<TFLOATSINK> floatSinkSupplier, Float reservedFloat, IntFunction<TDOUBLESINK> doubleSinkSupplier, Double reservedDouble, IntFunction<TBOOLASBYTESINK> booleanAsByteSinkSupplier, IntFunction<TCHARSINK> charSinkSupplier, Character reservedChar, IntFunction<TSTRINGSINK> stringSinkSupplier, String reservedString, IntFunction<TDATETIMEASLONGSINK> dateTimeAsLongSinkSupplier, Long reservedDateTimeAsLong, IntFunction<TTIMESTAMPASLONGSINK> timestampAsLongSinkSupplier, Long reservedTimestampAsLong) {
        this.reservedByte = reservedByte;
        this.reservedShort = reservedShort;
        this.reservedInt = reservedInt;
        this.reservedLong = reservedLong;
        this.floatSinkSupplier = floatSinkSupplier;
        this.reservedFloat = reservedFloat;
        this.doubleSinkSupplier = doubleSinkSupplier;
        this.reservedDouble = reservedDouble;
        this.booleanAsByteSinkSupplier = booleanAsByteSinkSupplier;
        this.charSinkSupplier = charSinkSupplier;
        this.reservedChar = reservedChar;
        this.stringSinkSupplier = stringSinkSupplier;
        this.reservedString = reservedString;
        this.dateTimeAsLongSinkSupplier = dateTimeAsLongSinkSupplier;
        this.reservedDateTimeAsLong = reservedDateTimeAsLong;
        this.timestampAsLongSinkSupplier = timestampAsLongSinkSupplier;
        this.reservedTimestampAsLong = reservedTimestampAsLong;
    }

    @Override
    public final Byte reservedByte() {
        return this.reservedByte;
    }

    @Override
    public final Short reservedShort() {
        return this.reservedShort;
    }

    @Override
    public final Integer reservedInt() {
        return this.reservedInt;
    }

    @Override
    public final Long reservedLong() {
        return this.reservedLong;
    }

    @Override
    public final synchronized Sink<float[]> forFloat(int colNum) {
        return (Sink)this.floatSinkSupplier.apply(colNum);
    }

    @Override
    public final Float reservedFloat() {
        return this.reservedFloat;
    }

    @Override
    public final synchronized Sink<double[]> forDouble(int colNum) {
        return (Sink)this.doubleSinkSupplier.apply(colNum);
    }

    @Override
    public final Double reservedDouble() {
        return this.reservedDouble;
    }

    @Override
    public final synchronized Sink<byte[]> forBooleanAsByte(int colNum) {
        return (Sink)this.booleanAsByteSinkSupplier.apply(colNum);
    }

    @Override
    public final synchronized Sink<char[]> forChar(int colNum) {
        return (Sink)this.charSinkSupplier.apply(colNum);
    }

    @Override
    public final Character reservedChar() {
        return this.reservedChar;
    }

    @Override
    public final synchronized Sink<String[]> forString(int colNum) {
        return (Sink)this.stringSinkSupplier.apply(colNum);
    }

    @Override
    public final String reservedString() {
        return this.reservedString;
    }

    @Override
    public final synchronized Sink<long[]> forDateTimeAsLong(int colNum) {
        return (Sink)this.dateTimeAsLongSinkSupplier.apply(colNum);
    }

    @Override
    public final Long reservedDateTimeAsLong() {
        return this.reservedDateTimeAsLong;
    }

    @Override
    public final synchronized Sink<long[]> forTimestampAsLong(int colNum) {
        return (Sink)this.timestampAsLongSinkSupplier.apply(colNum);
    }

    @Override
    public final Long reservedTimestampAsLong() {
        return this.reservedTimestampAsLong;
    }
}

