/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.tokenization.Tokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

@Generated(from="CsvSpecs", generator="Immutables")
final class ImmutableCsvSpecs
extends CsvSpecs {
    private final List<String> headers;
    private final Map<Integer, String> headerForIndex;
    private final List<Parser<?>> parsers;
    private final Map<String, Parser<?>> parserForName;
    private final Map<Integer, Parser<?>> parserForIndex;
    private final List<String> nullValueLiterals;
    private final Map<String, List<String>> nullValueLiteralsForName;
    private final Map<Integer, List<String>> nullValueLiteralsForIndex;
    @Nullable
    private final Parser<?> nullParser;
    private final Tokenizer.CustomDoubleParser customDoubleParser;
    @Nullable
    private final Tokenizer.CustomTimeZoneParser customTimeZoneParser;
    private final Function<String[], String[]> headerLegalizer;
    private final Predicate<String> headerValidator;
    private final long skipRows;
    private final long numRows;
    private final boolean ignoreEmptyLines;
    private final boolean allowMissingColumns;
    private final boolean ignoreExcessColumns;
    private final boolean hasHeaderRow;
    private final char delimiter;
    private final char quote;
    private final boolean ignoreSurroundingSpaces;
    private final boolean trim;
    private final boolean concurrent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCsvSpecs(Builder builder) {
        this.headers = ImmutableCsvSpecs.createUnmodifiableList(true, builder.headers);
        this.headerForIndex = ImmutableCsvSpecs.createUnmodifiableMap(false, false, builder.headerForIndex);
        this.parserForName = ImmutableCsvSpecs.createUnmodifiableMap(false, false, builder.parserForName);
        this.parserForIndex = ImmutableCsvSpecs.createUnmodifiableMap(false, false, builder.parserForIndex);
        this.nullValueLiteralsForName = ImmutableCsvSpecs.createUnmodifiableMap(false, false, builder.nullValueLiteralsForName);
        this.nullValueLiteralsForIndex = ImmutableCsvSpecs.createUnmodifiableMap(false, false, builder.nullValueLiteralsForIndex);
        if (builder.parsersIsSet()) {
            this.initShim.parsers(ImmutableCsvSpecs.createUnmodifiableList(true, builder.parsers));
        }
        if (builder.nullValueLiteralsIsSet()) {
            this.initShim.nullValueLiterals(ImmutableCsvSpecs.createUnmodifiableList(true, builder.nullValueLiterals));
        }
        if (builder.nullParserIsSet()) {
            this.initShim.nullParser(builder.nullParser);
        }
        if (builder.customDoubleParser != null) {
            this.initShim.customDoubleParser(builder.customDoubleParser);
        }
        if (builder.customTimeZoneParserIsSet()) {
            this.initShim.customTimeZoneParser(builder.customTimeZoneParser);
        }
        if (builder.headerLegalizer != null) {
            this.initShim.headerLegalizer(builder.headerLegalizer);
        }
        if (builder.headerValidator != null) {
            this.initShim.headerValidator(builder.headerValidator);
        }
        if (builder.skipRowsIsSet()) {
            this.initShim.skipRows(builder.skipRows);
        }
        if (builder.numRowsIsSet()) {
            this.initShim.numRows(builder.numRows);
        }
        if (builder.ignoreEmptyLinesIsSet()) {
            this.initShim.ignoreEmptyLines(builder.ignoreEmptyLines);
        }
        if (builder.allowMissingColumnsIsSet()) {
            this.initShim.allowMissingColumns(builder.allowMissingColumns);
        }
        if (builder.ignoreExcessColumnsIsSet()) {
            this.initShim.ignoreExcessColumns(builder.ignoreExcessColumns);
        }
        if (builder.hasHeaderRowIsSet()) {
            this.initShim.hasHeaderRow(builder.hasHeaderRow);
        }
        if (builder.delimiterIsSet()) {
            this.initShim.delimiter(builder.delimiter);
        }
        if (builder.quoteIsSet()) {
            this.initShim.quote(builder.quote);
        }
        if (builder.ignoreSurroundingSpacesIsSet()) {
            this.initShim.ignoreSurroundingSpaces(builder.ignoreSurroundingSpaces);
        }
        if (builder.trimIsSet()) {
            this.initShim.trim(builder.trim);
        }
        if (builder.concurrentIsSet()) {
            this.initShim.concurrent(builder.concurrent);
        }
        this.parsers = this.initShim.parsers();
        this.nullValueLiterals = this.initShim.nullValueLiterals();
        this.nullParser = this.initShim.nullParser();
        this.customDoubleParser = this.initShim.customDoubleParser();
        this.customTimeZoneParser = this.initShim.customTimeZoneParser();
        this.headerLegalizer = this.initShim.headerLegalizer();
        this.headerValidator = this.initShim.headerValidator();
        this.skipRows = this.initShim.skipRows();
        this.numRows = this.initShim.numRows();
        this.ignoreEmptyLines = this.initShim.ignoreEmptyLines();
        this.allowMissingColumns = this.initShim.allowMissingColumns();
        this.ignoreExcessColumns = this.initShim.ignoreExcessColumns();
        this.hasHeaderRow = this.initShim.hasHeaderRow();
        this.delimiter = this.initShim.delimiter();
        this.quote = this.initShim.quote();
        this.ignoreSurroundingSpaces = this.initShim.ignoreSurroundingSpaces();
        this.trim = this.initShim.trim();
        this.concurrent = this.initShim.concurrent();
        this.initShim = null;
    }

    @Override
    public List<String> headers() {
        return this.headers;
    }

    @Override
    public Map<Integer, String> headerForIndex() {
        return this.headerForIndex;
    }

    @Override
    public List<Parser<?>> parsers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parsers() : this.parsers;
    }

    @Override
    public Map<String, Parser<?>> parserForName() {
        return this.parserForName;
    }

    @Override
    public Map<Integer, Parser<?>> parserForIndex() {
        return this.parserForIndex;
    }

    @Override
    public List<String> nullValueLiterals() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nullValueLiterals() : this.nullValueLiterals;
    }

    @Override
    public Map<String, List<String>> nullValueLiteralsForName() {
        return this.nullValueLiteralsForName;
    }

    @Override
    public Map<Integer, List<String>> nullValueLiteralsForIndex() {
        return this.nullValueLiteralsForIndex;
    }

    @Override
    @Nullable
    public Parser<?> nullParser() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nullParser() : this.nullParser;
    }

    @Override
    public Tokenizer.CustomDoubleParser customDoubleParser() {
        InitShim shim = this.initShim;
        return shim != null ? shim.customDoubleParser() : this.customDoubleParser;
    }

    @Override
    @Nullable
    public Tokenizer.CustomTimeZoneParser customTimeZoneParser() {
        InitShim shim = this.initShim;
        return shim != null ? shim.customTimeZoneParser() : this.customTimeZoneParser;
    }

    @Override
    public Function<String[], String[]> headerLegalizer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.headerLegalizer() : this.headerLegalizer;
    }

    @Override
    public Predicate<String> headerValidator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.headerValidator() : this.headerValidator;
    }

    @Override
    public long skipRows() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skipRows() : this.skipRows;
    }

    @Override
    public long numRows() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numRows() : this.numRows;
    }

    @Override
    public boolean ignoreEmptyLines() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ignoreEmptyLines() : this.ignoreEmptyLines;
    }

    @Override
    public boolean allowMissingColumns() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowMissingColumns() : this.allowMissingColumns;
    }

    @Override
    public boolean ignoreExcessColumns() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ignoreExcessColumns() : this.ignoreExcessColumns;
    }

    @Override
    public boolean hasHeaderRow() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasHeaderRow() : this.hasHeaderRow;
    }

    @Override
    public char delimiter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.delimiter() : this.delimiter;
    }

    @Override
    public char quote() {
        InitShim shim = this.initShim;
        return shim != null ? shim.quote() : this.quote;
    }

    @Override
    public boolean ignoreSurroundingSpaces() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ignoreSurroundingSpaces() : this.ignoreSurroundingSpaces;
    }

    @Override
    public boolean trim() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trim() : this.trim;
    }

    @Override
    public boolean concurrent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrent() : this.concurrent;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCsvSpecs && this.equalTo(0, (ImmutableCsvSpecs)another);
    }

    private boolean equalTo(int synthetic, ImmutableCsvSpecs another) {
        return this.headers.equals(another.headers) && this.headerForIndex.equals(another.headerForIndex) && this.parsers.equals(another.parsers) && this.parserForName.equals(another.parserForName) && this.parserForIndex.equals(another.parserForIndex) && this.nullValueLiterals.equals(another.nullValueLiterals) && this.nullValueLiteralsForName.equals(another.nullValueLiteralsForName) && this.nullValueLiteralsForIndex.equals(another.nullValueLiteralsForIndex) && Objects.equals(this.nullParser, another.nullParser) && this.customDoubleParser.equals(another.customDoubleParser) && Objects.equals(this.customTimeZoneParser, another.customTimeZoneParser) && this.headerLegalizer.equals(another.headerLegalizer) && this.headerValidator.equals(another.headerValidator) && this.skipRows == another.skipRows && this.numRows == another.numRows && this.ignoreEmptyLines == another.ignoreEmptyLines && this.allowMissingColumns == another.allowMissingColumns && this.ignoreExcessColumns == another.ignoreExcessColumns && this.hasHeaderRow == another.hasHeaderRow && this.delimiter == another.delimiter && this.quote == another.quote && this.ignoreSurroundingSpaces == another.ignoreSurroundingSpaces && this.trim == another.trim && this.concurrent == another.concurrent;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.headers.hashCode();
        h += (h << 5) + this.headerForIndex.hashCode();
        h += (h << 5) + this.parsers.hashCode();
        h += (h << 5) + this.parserForName.hashCode();
        h += (h << 5) + this.parserForIndex.hashCode();
        h += (h << 5) + this.nullValueLiterals.hashCode();
        h += (h << 5) + this.nullValueLiteralsForName.hashCode();
        h += (h << 5) + this.nullValueLiteralsForIndex.hashCode();
        h += (h << 5) + Objects.hashCode(this.nullParser);
        h += (h << 5) + this.customDoubleParser.hashCode();
        h += (h << 5) + Objects.hashCode(this.customTimeZoneParser);
        h += (h << 5) + this.headerLegalizer.hashCode();
        h += (h << 5) + this.headerValidator.hashCode();
        h += (h << 5) + Long.hashCode(this.skipRows);
        h += (h << 5) + Long.hashCode(this.numRows);
        h += (h << 5) + Boolean.hashCode(this.ignoreEmptyLines);
        h += (h << 5) + Boolean.hashCode(this.allowMissingColumns);
        h += (h << 5) + Boolean.hashCode(this.ignoreExcessColumns);
        h += (h << 5) + Boolean.hashCode(this.hasHeaderRow);
        h += (h << 5) + Character.hashCode(this.delimiter);
        h += (h << 5) + Character.hashCode(this.quote);
        h += (h << 5) + Boolean.hashCode(this.ignoreSurroundingSpaces);
        h += (h << 5) + Boolean.hashCode(this.trim);
        h += (h << 5) + Boolean.hashCode(this.concurrent);
        return h;
    }

    public String toString() {
        return "CsvSpecs{headers=" + this.headers + ", headerForIndex=" + this.headerForIndex + ", parsers=" + this.parsers + ", parserForName=" + this.parserForName + ", parserForIndex=" + this.parserForIndex + ", nullValueLiterals=" + this.nullValueLiterals + ", nullValueLiteralsForName=" + this.nullValueLiteralsForName + ", nullValueLiteralsForIndex=" + this.nullValueLiteralsForIndex + ", nullParser=" + this.nullParser + ", customDoubleParser=" + this.customDoubleParser + ", customTimeZoneParser=" + this.customTimeZoneParser + ", headerLegalizer=" + this.headerLegalizer + ", headerValidator=" + this.headerValidator + ", skipRows=" + this.skipRows + ", numRows=" + this.numRows + ", ignoreEmptyLines=" + this.ignoreEmptyLines + ", allowMissingColumns=" + this.allowMissingColumns + ", ignoreExcessColumns=" + this.ignoreExcessColumns + ", hasHeaderRow=" + this.hasHeaderRow + ", delimiter=" + this.delimiter + ", quote=" + this.quote + ", ignoreSurroundingSpaces=" + this.ignoreSurroundingSpaces + ", trim=" + this.trim + ", concurrent=" + this.concurrent + "}";
    }

    private static ImmutableCsvSpecs validate(ImmutableCsvSpecs instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CsvSpecs", generator="Immutables")
    public static final class Builder
    implements CsvSpecs.Builder {
        private static final long OPT_BIT_PARSERS = 1L;
        private static final long OPT_BIT_NULL_VALUE_LITERALS = 2L;
        private static final long OPT_BIT_NULL_PARSER = 4L;
        private static final long OPT_BIT_CUSTOM_TIME_ZONE_PARSER = 8L;
        private static final long OPT_BIT_SKIP_ROWS = 16L;
        private static final long OPT_BIT_NUM_ROWS = 32L;
        private static final long OPT_BIT_IGNORE_EMPTY_LINES = 64L;
        private static final long OPT_BIT_ALLOW_MISSING_COLUMNS = 128L;
        private static final long OPT_BIT_IGNORE_EXCESS_COLUMNS = 256L;
        private static final long OPT_BIT_HAS_HEADER_ROW = 512L;
        private static final long OPT_BIT_DELIMITER = 1024L;
        private static final long OPT_BIT_QUOTE = 2048L;
        private static final long OPT_BIT_IGNORE_SURROUNDING_SPACES = 4096L;
        private static final long OPT_BIT_TRIM = 8192L;
        private static final long OPT_BIT_CONCURRENT = 16384L;
        private long optBits;
        private List<String> headers = new ArrayList<String>();
        private Map<Integer, String> headerForIndex = new LinkedHashMap<Integer, String>();
        private List<Parser<?>> parsers = new ArrayList();
        private Map<String, Parser<?>> parserForName = new LinkedHashMap();
        private Map<Integer, Parser<?>> parserForIndex = new LinkedHashMap();
        private List<String> nullValueLiterals = new ArrayList<String>();
        private Map<String, List<String>> nullValueLiteralsForName = new LinkedHashMap<String, List<String>>();
        private Map<Integer, List<String>> nullValueLiteralsForIndex = new LinkedHashMap<Integer, List<String>>();
        private Parser<?> nullParser;
        private Tokenizer.CustomDoubleParser customDoubleParser;
        private Tokenizer.CustomTimeZoneParser customTimeZoneParser;
        private Function<String[], String[]> headerLegalizer;
        private Predicate<String> headerValidator;
        private long skipRows;
        private long numRows;
        private boolean ignoreEmptyLines;
        private boolean allowMissingColumns;
        private boolean ignoreExcessColumns;
        private boolean hasHeaderRow;
        private char delimiter;
        private char quote;
        private boolean ignoreSurroundingSpaces;
        private boolean trim;
        private boolean concurrent;

        private Builder() {
        }

        @Override
        public final Builder from(CsvSpecs instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllHeaders(instance.headers());
            this.putAllHeaderForIndex(instance.headerForIndex());
            this.addAllParsers(instance.parsers());
            this.putAllParserForName(instance.parserForName());
            this.putAllParserForIndex(instance.parserForIndex());
            this.addAllNullValueLiterals(instance.nullValueLiterals());
            this.putAllNullValueLiteralsForName(instance.nullValueLiteralsForName());
            this.putAllNullValueLiteralsForIndex(instance.nullValueLiteralsForIndex());
            @Nullable Parser<?> nullParserValue = instance.nullParser();
            if (nullParserValue != null) {
                this.nullParser((Parser)nullParserValue);
            }
            this.customDoubleParser(instance.customDoubleParser());
            @Nullable Tokenizer.CustomTimeZoneParser customTimeZoneParserValue = instance.customTimeZoneParser();
            if (customTimeZoneParserValue != null) {
                this.customTimeZoneParser(customTimeZoneParserValue);
            }
            this.headerLegalizer((Function)instance.headerLegalizer());
            this.headerValidator((Predicate)instance.headerValidator());
            this.skipRows(instance.skipRows());
            this.numRows(instance.numRows());
            this.ignoreEmptyLines(instance.ignoreEmptyLines());
            this.allowMissingColumns(instance.allowMissingColumns());
            this.ignoreExcessColumns(instance.ignoreExcessColumns());
            this.hasHeaderRow(instance.hasHeaderRow());
            this.delimiter(instance.delimiter());
            this.quote(instance.quote());
            this.ignoreSurroundingSpaces(instance.ignoreSurroundingSpaces());
            this.trim(instance.trim());
            this.concurrent(instance.concurrent());
            return this;
        }

        public final Builder addHeaders(String element) {
            this.headers.add(Objects.requireNonNull(element, "headers element"));
            return this;
        }

        public final Builder addHeaders(String ... elements) {
            for (String element : elements) {
                this.headers.add(Objects.requireNonNull(element, "headers element"));
            }
            return this;
        }

        @Override
        public final Builder headers(Iterable<String> elements) {
            this.headers.clear();
            return this.addAllHeaders(elements);
        }

        public final Builder addAllHeaders(Iterable<String> elements) {
            for (String element : elements) {
                this.headers.add(Objects.requireNonNull(element, "headers element"));
            }
            return this;
        }

        @Override
        public final Builder putHeaderForIndex(int key, String value) {
            this.headerForIndex.put(Objects.requireNonNull(Integer.valueOf(key), "headerForIndex key"), Objects.requireNonNull(value, "headerForIndex value"));
            return this;
        }

        public final Builder putHeaderForIndex(Map.Entry<Integer, ? extends String> entry) {
            Integer k = entry.getKey();
            String v = entry.getValue();
            this.headerForIndex.put(Objects.requireNonNull(k, "headerForIndex key"), Objects.requireNonNull(v, "headerForIndex value"));
            return this;
        }

        public final Builder headerForIndex(Map<Integer, ? extends String> entries) {
            this.headerForIndex.clear();
            return this.putAllHeaderForIndex(entries);
        }

        public final Builder putAllHeaderForIndex(Map<Integer, ? extends String> entries) {
            for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
                Integer k = e.getKey();
                String v = e.getValue();
                this.headerForIndex.put(Objects.requireNonNull(k, "headerForIndex key"), Objects.requireNonNull(v, "headerForIndex value"));
            }
            return this;
        }

        public final Builder addParsers(Parser<?> element) {
            this.parsers.add(Objects.requireNonNull(element, "parsers element"));
            this.optBits |= 1L;
            return this;
        }

        @SafeVarargs
        public final Builder addParsers(Parser<?> ... elements) {
            for (Parser<?> element : elements) {
                this.parsers.add(Objects.requireNonNull(element, "parsers element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder parsers(Iterable<? extends Parser<?>> elements) {
            this.parsers.clear();
            return this.addAllParsers(elements);
        }

        public final Builder addAllParsers(Iterable<? extends Parser<?>> elements) {
            for (Parser<?> element : elements) {
                this.parsers.add(Objects.requireNonNull(element, "parsers element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder putParserForName(String key, Parser<?> value) {
            this.parserForName.put(Objects.requireNonNull(key, "parserForName key"), Objects.requireNonNull(value, "parserForName value"));
            return this;
        }

        public final Builder putParserForName(Map.Entry<String, ? extends Parser<?>> entry) {
            String k = entry.getKey();
            Parser<?> v = entry.getValue();
            this.parserForName.put(Objects.requireNonNull(k, "parserForName key"), Objects.requireNonNull(v, "parserForName value"));
            return this;
        }

        public final Builder parserForName(Map<String, ? extends Parser<?>> entries) {
            this.parserForName.clear();
            return this.putAllParserForName(entries);
        }

        public final Builder putAllParserForName(Map<String, ? extends Parser<?>> entries) {
            for (Map.Entry<String, Parser<?>> e : entries.entrySet()) {
                String k = e.getKey();
                Parser<?> v = e.getValue();
                this.parserForName.put(Objects.requireNonNull(k, "parserForName key"), Objects.requireNonNull(v, "parserForName value"));
            }
            return this;
        }

        @Override
        public final Builder putParserForIndex(int key, Parser<?> value) {
            this.parserForIndex.put(Objects.requireNonNull(Integer.valueOf(key), "parserForIndex key"), Objects.requireNonNull(value, "parserForIndex value"));
            return this;
        }

        public final Builder putParserForIndex(Map.Entry<Integer, ? extends Parser<?>> entry) {
            Integer k = entry.getKey();
            Parser<?> v = entry.getValue();
            this.parserForIndex.put(Objects.requireNonNull(k, "parserForIndex key"), Objects.requireNonNull(v, "parserForIndex value"));
            return this;
        }

        public final Builder parserForIndex(Map<Integer, ? extends Parser<?>> entries) {
            this.parserForIndex.clear();
            return this.putAllParserForIndex(entries);
        }

        public final Builder putAllParserForIndex(Map<Integer, ? extends Parser<?>> entries) {
            for (Map.Entry<Integer, Parser<?>> e : entries.entrySet()) {
                Integer k = e.getKey();
                Parser<?> v = e.getValue();
                this.parserForIndex.put(Objects.requireNonNull(k, "parserForIndex key"), Objects.requireNonNull(v, "parserForIndex value"));
            }
            return this;
        }

        public final Builder addNullValueLiterals(String element) {
            this.nullValueLiterals.add(Objects.requireNonNull(element, "nullValueLiterals element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addNullValueLiterals(String ... elements) {
            for (String element : elements) {
                this.nullValueLiterals.add(Objects.requireNonNull(element, "nullValueLiterals element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        public final Builder nullValueLiterals(Iterable<String> elements) {
            this.nullValueLiterals.clear();
            return this.addAllNullValueLiterals(elements);
        }

        public final Builder addAllNullValueLiterals(Iterable<String> elements) {
            for (String element : elements) {
                this.nullValueLiterals.add(Objects.requireNonNull(element, "nullValueLiterals element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @Override
        public final Builder putNullValueLiteralsForName(String key, List<String> value) {
            this.nullValueLiteralsForName.put(Objects.requireNonNull(key, "nullValueLiteralsForName key"), Objects.requireNonNull(value, "nullValueLiteralsForName value"));
            return this;
        }

        public final Builder putNullValueLiteralsForName(Map.Entry<String, ? extends List<String>> entry) {
            String k = entry.getKey();
            List<String> v = entry.getValue();
            this.nullValueLiteralsForName.put(Objects.requireNonNull(k, "nullValueLiteralsForName key"), Objects.requireNonNull(v, "nullValueLiteralsForName value"));
            return this;
        }

        public final Builder nullValueLiteralsForName(Map<String, ? extends List<String>> entries) {
            this.nullValueLiteralsForName.clear();
            return this.putAllNullValueLiteralsForName(entries);
        }

        public final Builder putAllNullValueLiteralsForName(Map<String, ? extends List<String>> entries) {
            for (Map.Entry<String, ? extends List<String>> e : entries.entrySet()) {
                String k = e.getKey();
                List<String> v = e.getValue();
                this.nullValueLiteralsForName.put(Objects.requireNonNull(k, "nullValueLiteralsForName key"), Objects.requireNonNull(v, "nullValueLiteralsForName value"));
            }
            return this;
        }

        @Override
        public final Builder putNullValueLiteralsForIndex(int key, List<String> value) {
            this.nullValueLiteralsForIndex.put(Objects.requireNonNull(Integer.valueOf(key), "nullValueLiteralsForIndex key"), Objects.requireNonNull(value, "nullValueLiteralsForIndex value"));
            return this;
        }

        public final Builder putNullValueLiteralsForIndex(Map.Entry<Integer, ? extends List<String>> entry) {
            Integer k = entry.getKey();
            List<String> v = entry.getValue();
            this.nullValueLiteralsForIndex.put(Objects.requireNonNull(k, "nullValueLiteralsForIndex key"), Objects.requireNonNull(v, "nullValueLiteralsForIndex value"));
            return this;
        }

        public final Builder nullValueLiteralsForIndex(Map<Integer, ? extends List<String>> entries) {
            this.nullValueLiteralsForIndex.clear();
            return this.putAllNullValueLiteralsForIndex(entries);
        }

        public final Builder putAllNullValueLiteralsForIndex(Map<Integer, ? extends List<String>> entries) {
            for (Map.Entry<Integer, ? extends List<String>> e : entries.entrySet()) {
                Integer k = e.getKey();
                List<String> v = e.getValue();
                this.nullValueLiteralsForIndex.put(Objects.requireNonNull(k, "nullValueLiteralsForIndex key"), Objects.requireNonNull(v, "nullValueLiteralsForIndex value"));
            }
            return this;
        }

        @Override
        public final Builder nullParser(@Nullable Parser<?> nullParser) {
            this.nullParser = nullParser;
            this.optBits |= 4L;
            return this;
        }

        @Override
        public final Builder customDoubleParser(Tokenizer.CustomDoubleParser customDoubleParser) {
            this.customDoubleParser = Objects.requireNonNull(customDoubleParser, "customDoubleParser");
            return this;
        }

        @Override
        public final Builder customTimeZoneParser(@Nullable Tokenizer.CustomTimeZoneParser customTimeZoneParser) {
            this.customTimeZoneParser = customTimeZoneParser;
            this.optBits |= 8L;
            return this;
        }

        @Override
        public final Builder headerLegalizer(Function<String[], String[]> headerLegalizer) {
            this.headerLegalizer = Objects.requireNonNull(headerLegalizer, "headerLegalizer");
            return this;
        }

        @Override
        public final Builder headerValidator(Predicate<String> headerValidator) {
            this.headerValidator = Objects.requireNonNull(headerValidator, "headerValidator");
            return this;
        }

        @Override
        public final Builder skipRows(long skipRows) {
            this.skipRows = skipRows;
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        public final Builder numRows(long numRows) {
            this.numRows = numRows;
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        public final Builder ignoreEmptyLines(boolean ignoreEmptyLines) {
            this.ignoreEmptyLines = ignoreEmptyLines;
            this.optBits |= 0x40L;
            return this;
        }

        @Override
        public final Builder allowMissingColumns(boolean allowMissingColumns) {
            this.allowMissingColumns = allowMissingColumns;
            this.optBits |= 0x80L;
            return this;
        }

        @Override
        public final Builder ignoreExcessColumns(boolean ignoreExcessColumns) {
            this.ignoreExcessColumns = ignoreExcessColumns;
            this.optBits |= 0x100L;
            return this;
        }

        @Override
        public final Builder hasHeaderRow(boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            this.optBits |= 0x200L;
            return this;
        }

        @Override
        public final Builder delimiter(char delimiter) {
            this.delimiter = delimiter;
            this.optBits |= 0x400L;
            return this;
        }

        @Override
        public final Builder quote(char quote) {
            this.quote = quote;
            this.optBits |= 0x800L;
            return this;
        }

        @Override
        public final Builder ignoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
            this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
            this.optBits |= 0x1000L;
            return this;
        }

        @Override
        public final Builder trim(boolean trim) {
            this.trim = trim;
            this.optBits |= 0x2000L;
            return this;
        }

        @Override
        public final Builder concurrent(boolean concurrent) {
            this.concurrent = concurrent;
            this.optBits |= 0x4000L;
            return this;
        }

        @Override
        public ImmutableCsvSpecs build() {
            return ImmutableCsvSpecs.validate(new ImmutableCsvSpecs(this));
        }

        private boolean parsersIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean nullValueLiteralsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nullParserIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean customTimeZoneParserIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean skipRowsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean numRowsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean ignoreEmptyLinesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean allowMissingColumnsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean ignoreExcessColumnsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean hasHeaderRowIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean delimiterIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean quoteIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean ignoreSurroundingSpacesIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean trimIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean concurrentIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }
    }

    @Generated(from="CsvSpecs", generator="Immutables")
    private final class InitShim {
        private byte parsersBuildStage = 0;
        private List<Parser<?>> parsers;
        private byte nullValueLiteralsBuildStage = 0;
        private List<String> nullValueLiterals;
        private byte nullParserBuildStage = 0;
        private Parser<?> nullParser;
        private byte customDoubleParserBuildStage = 0;
        private Tokenizer.CustomDoubleParser customDoubleParser;
        private byte customTimeZoneParserBuildStage = 0;
        private Tokenizer.CustomTimeZoneParser customTimeZoneParser;
        private byte headerLegalizerBuildStage = 0;
        private Function<String[], String[]> headerLegalizer;
        private byte headerValidatorBuildStage = 0;
        private Predicate<String> headerValidator;
        private byte skipRowsBuildStage = 0;
        private long skipRows;
        private byte numRowsBuildStage = 0;
        private long numRows;
        private byte ignoreEmptyLinesBuildStage = 0;
        private boolean ignoreEmptyLines;
        private byte allowMissingColumnsBuildStage = 0;
        private boolean allowMissingColumns;
        private byte ignoreExcessColumnsBuildStage = 0;
        private boolean ignoreExcessColumns;
        private byte hasHeaderRowBuildStage = 0;
        private boolean hasHeaderRow;
        private byte delimiterBuildStage = 0;
        private char delimiter;
        private byte quoteBuildStage = 0;
        private char quote;
        private byte ignoreSurroundingSpacesBuildStage = 0;
        private boolean ignoreSurroundingSpaces;
        private byte trimBuildStage = 0;
        private boolean trim;
        private byte concurrentBuildStage = 0;
        private boolean concurrent;

        private InitShim() {
        }

        List<Parser<?>> parsers() {
            if (this.parsersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parsersBuildStage == 0) {
                this.parsersBuildStage = (byte)-1;
                this.parsers = ImmutableCsvSpecs.createUnmodifiableList(false, ImmutableCsvSpecs.createSafeList(ImmutableCsvSpecs.super.parsers(), true, false));
                this.parsersBuildStage = 1;
            }
            return this.parsers;
        }

        void parsers(List<Parser<?>> parsers) {
            this.parsers = parsers;
            this.parsersBuildStage = 1;
        }

        List<String> nullValueLiterals() {
            if (this.nullValueLiteralsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nullValueLiteralsBuildStage == 0) {
                this.nullValueLiteralsBuildStage = (byte)-1;
                this.nullValueLiterals = ImmutableCsvSpecs.createUnmodifiableList(false, ImmutableCsvSpecs.createSafeList(ImmutableCsvSpecs.super.nullValueLiterals(), true, false));
                this.nullValueLiteralsBuildStage = 1;
            }
            return this.nullValueLiterals;
        }

        void nullValueLiterals(List<String> nullValueLiterals) {
            this.nullValueLiterals = nullValueLiterals;
            this.nullValueLiteralsBuildStage = 1;
        }

        Parser<?> nullParser() {
            if (this.nullParserBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nullParserBuildStage == 0) {
                this.nullParserBuildStage = (byte)-1;
                this.nullParser = ImmutableCsvSpecs.super.nullParser();
                this.nullParserBuildStage = 1;
            }
            return this.nullParser;
        }

        void nullParser(Parser<?> nullParser) {
            this.nullParser = nullParser;
            this.nullParserBuildStage = 1;
        }

        Tokenizer.CustomDoubleParser customDoubleParser() {
            if (this.customDoubleParserBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.customDoubleParserBuildStage == 0) {
                this.customDoubleParserBuildStage = (byte)-1;
                this.customDoubleParser = Objects.requireNonNull(ImmutableCsvSpecs.super.customDoubleParser(), "customDoubleParser");
                this.customDoubleParserBuildStage = 1;
            }
            return this.customDoubleParser;
        }

        void customDoubleParser(Tokenizer.CustomDoubleParser customDoubleParser) {
            this.customDoubleParser = customDoubleParser;
            this.customDoubleParserBuildStage = 1;
        }

        Tokenizer.CustomTimeZoneParser customTimeZoneParser() {
            if (this.customTimeZoneParserBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.customTimeZoneParserBuildStage == 0) {
                this.customTimeZoneParserBuildStage = (byte)-1;
                this.customTimeZoneParser = ImmutableCsvSpecs.super.customTimeZoneParser();
                this.customTimeZoneParserBuildStage = 1;
            }
            return this.customTimeZoneParser;
        }

        void customTimeZoneParser(Tokenizer.CustomTimeZoneParser customTimeZoneParser) {
            this.customTimeZoneParser = customTimeZoneParser;
            this.customTimeZoneParserBuildStage = 1;
        }

        Function<String[], String[]> headerLegalizer() {
            if (this.headerLegalizerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.headerLegalizerBuildStage == 0) {
                this.headerLegalizerBuildStage = (byte)-1;
                this.headerLegalizer = Objects.requireNonNull(ImmutableCsvSpecs.super.headerLegalizer(), "headerLegalizer");
                this.headerLegalizerBuildStage = 1;
            }
            return this.headerLegalizer;
        }

        void headerLegalizer(Function<String[], String[]> headerLegalizer) {
            this.headerLegalizer = headerLegalizer;
            this.headerLegalizerBuildStage = 1;
        }

        Predicate<String> headerValidator() {
            if (this.headerValidatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.headerValidatorBuildStage == 0) {
                this.headerValidatorBuildStage = (byte)-1;
                this.headerValidator = Objects.requireNonNull(ImmutableCsvSpecs.super.headerValidator(), "headerValidator");
                this.headerValidatorBuildStage = 1;
            }
            return this.headerValidator;
        }

        void headerValidator(Predicate<String> headerValidator) {
            this.headerValidator = headerValidator;
            this.headerValidatorBuildStage = 1;
        }

        long skipRows() {
            if (this.skipRowsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skipRowsBuildStage == 0) {
                this.skipRowsBuildStage = (byte)-1;
                this.skipRows = ImmutableCsvSpecs.super.skipRows();
                this.skipRowsBuildStage = 1;
            }
            return this.skipRows;
        }

        void skipRows(long skipRows) {
            this.skipRows = skipRows;
            this.skipRowsBuildStage = 1;
        }

        long numRows() {
            if (this.numRowsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numRowsBuildStage == 0) {
                this.numRowsBuildStage = (byte)-1;
                this.numRows = ImmutableCsvSpecs.super.numRows();
                this.numRowsBuildStage = 1;
            }
            return this.numRows;
        }

        void numRows(long numRows) {
            this.numRows = numRows;
            this.numRowsBuildStage = 1;
        }

        boolean ignoreEmptyLines() {
            if (this.ignoreEmptyLinesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ignoreEmptyLinesBuildStage == 0) {
                this.ignoreEmptyLinesBuildStage = (byte)-1;
                this.ignoreEmptyLines = ImmutableCsvSpecs.super.ignoreEmptyLines();
                this.ignoreEmptyLinesBuildStage = 1;
            }
            return this.ignoreEmptyLines;
        }

        void ignoreEmptyLines(boolean ignoreEmptyLines) {
            this.ignoreEmptyLines = ignoreEmptyLines;
            this.ignoreEmptyLinesBuildStage = 1;
        }

        boolean allowMissingColumns() {
            if (this.allowMissingColumnsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowMissingColumnsBuildStage == 0) {
                this.allowMissingColumnsBuildStage = (byte)-1;
                this.allowMissingColumns = ImmutableCsvSpecs.super.allowMissingColumns();
                this.allowMissingColumnsBuildStage = 1;
            }
            return this.allowMissingColumns;
        }

        void allowMissingColumns(boolean allowMissingColumns) {
            this.allowMissingColumns = allowMissingColumns;
            this.allowMissingColumnsBuildStage = 1;
        }

        boolean ignoreExcessColumns() {
            if (this.ignoreExcessColumnsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ignoreExcessColumnsBuildStage == 0) {
                this.ignoreExcessColumnsBuildStage = (byte)-1;
                this.ignoreExcessColumns = ImmutableCsvSpecs.super.ignoreExcessColumns();
                this.ignoreExcessColumnsBuildStage = 1;
            }
            return this.ignoreExcessColumns;
        }

        void ignoreExcessColumns(boolean ignoreExcessColumns) {
            this.ignoreExcessColumns = ignoreExcessColumns;
            this.ignoreExcessColumnsBuildStage = 1;
        }

        boolean hasHeaderRow() {
            if (this.hasHeaderRowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasHeaderRowBuildStage == 0) {
                this.hasHeaderRowBuildStage = (byte)-1;
                this.hasHeaderRow = ImmutableCsvSpecs.super.hasHeaderRow();
                this.hasHeaderRowBuildStage = 1;
            }
            return this.hasHeaderRow;
        }

        void hasHeaderRow(boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            this.hasHeaderRowBuildStage = 1;
        }

        char delimiter() {
            if (this.delimiterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.delimiterBuildStage == 0) {
                this.delimiterBuildStage = (byte)-1;
                this.delimiter = ImmutableCsvSpecs.super.delimiter();
                this.delimiterBuildStage = 1;
            }
            return this.delimiter;
        }

        void delimiter(char delimiter) {
            this.delimiter = delimiter;
            this.delimiterBuildStage = 1;
        }

        char quote() {
            if (this.quoteBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.quoteBuildStage == 0) {
                this.quoteBuildStage = (byte)-1;
                this.quote = ImmutableCsvSpecs.super.quote();
                this.quoteBuildStage = 1;
            }
            return this.quote;
        }

        void quote(char quote) {
            this.quote = quote;
            this.quoteBuildStage = 1;
        }

        boolean ignoreSurroundingSpaces() {
            if (this.ignoreSurroundingSpacesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ignoreSurroundingSpacesBuildStage == 0) {
                this.ignoreSurroundingSpacesBuildStage = (byte)-1;
                this.ignoreSurroundingSpaces = ImmutableCsvSpecs.super.ignoreSurroundingSpaces();
                this.ignoreSurroundingSpacesBuildStage = 1;
            }
            return this.ignoreSurroundingSpaces;
        }

        void ignoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
            this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
            this.ignoreSurroundingSpacesBuildStage = 1;
        }

        boolean trim() {
            if (this.trimBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trimBuildStage == 0) {
                this.trimBuildStage = (byte)-1;
                this.trim = ImmutableCsvSpecs.super.trim();
                this.trimBuildStage = 1;
            }
            return this.trim;
        }

        void trim(boolean trim) {
            this.trim = trim;
            this.trimBuildStage = 1;
        }

        boolean concurrent() {
            if (this.concurrentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrentBuildStage == 0) {
                this.concurrentBuildStage = (byte)-1;
                this.concurrent = ImmutableCsvSpecs.super.concurrent();
                this.concurrentBuildStage = 1;
            }
            return this.concurrent;
        }

        void concurrent(boolean concurrent) {
            this.concurrent = concurrent;
            this.concurrentBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.parsersBuildStage == -1) {
                attributes.add("parsers");
            }
            if (this.nullValueLiteralsBuildStage == -1) {
                attributes.add("nullValueLiterals");
            }
            if (this.nullParserBuildStage == -1) {
                attributes.add("nullParser");
            }
            if (this.customDoubleParserBuildStage == -1) {
                attributes.add("customDoubleParser");
            }
            if (this.customTimeZoneParserBuildStage == -1) {
                attributes.add("customTimeZoneParser");
            }
            if (this.headerLegalizerBuildStage == -1) {
                attributes.add("headerLegalizer");
            }
            if (this.headerValidatorBuildStage == -1) {
                attributes.add("headerValidator");
            }
            if (this.skipRowsBuildStage == -1) {
                attributes.add("skipRows");
            }
            if (this.numRowsBuildStage == -1) {
                attributes.add("numRows");
            }
            if (this.ignoreEmptyLinesBuildStage == -1) {
                attributes.add("ignoreEmptyLines");
            }
            if (this.allowMissingColumnsBuildStage == -1) {
                attributes.add("allowMissingColumns");
            }
            if (this.ignoreExcessColumnsBuildStage == -1) {
                attributes.add("ignoreExcessColumns");
            }
            if (this.hasHeaderRowBuildStage == -1) {
                attributes.add("hasHeaderRow");
            }
            if (this.delimiterBuildStage == -1) {
                attributes.add("delimiter");
            }
            if (this.quoteBuildStage == -1) {
                attributes.add("quote");
            }
            if (this.ignoreSurroundingSpacesBuildStage == -1) {
                attributes.add("ignoreSurroundingSpaces");
            }
            if (this.trimBuildStage == -1) {
                attributes.add("trim");
            }
            if (this.concurrentBuildStage == -1) {
                attributes.add("concurrent");
            }
            return "Cannot build CsvSpecs, attribute initializers form cycle " + attributes;
        }
    }
}

