/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.densestorage;

import java.util.concurrent.Semaphore;

public final class QueueNode<TARRAY> {
    public final Semaphore semaphore;
    public final TARRAY data;
    public final int begin;
    public final int end;
    public final boolean isLast;
    public QueueNode<TARRAY> next;
    private boolean observed;

    public static <TARRAY> QueueNode<TARRAY> createInitial(int maxUnobservedBlocks) {
        Semaphore semaphore = new Semaphore(maxUnobservedBlocks);
        return new QueueNode<Object>(semaphore, null, 0, 0, false);
    }

    private QueueNode(Semaphore semaphore, TARRAY data, int begin, int end, boolean isLast) {
        this.semaphore = semaphore;
        this.data = data;
        this.begin = begin;
        this.end = end;
        this.isLast = isLast;
        this.next = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueNode<TARRAY> appendNextMaybeWait(TARRAY data, int begin, int end, boolean isLast) {
        try {
            this.semaphore.acquire(1);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Thread interrupted", ie);
        }
        QueueNode queueNode = this;
        synchronized (queueNode) {
            if (this.next != null) {
                throw new RuntimeException("next is already set");
            }
            this.next = new QueueNode<TARRAY>(this.semaphore, data, begin, end, isLast);
            this.notifyAll();
            return this.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueNode<TARRAY> waitForNext() {
        boolean needsRelease;
        QueueNode queueNode = this;
        synchronized (queueNode) {
            while (this.next == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Thread interrupted", ie);
                }
            }
            needsRelease = !this.observed;
            this.observed = true;
        }
        if (needsRelease) {
            this.semaphore.release();
        }
        return this.next;
    }
}

