/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.densestorage;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.QueueNode;
import io.deephaven.csv.densestorage.QueueReader;
import io.deephaven.csv.util.Pair;
import java.util.function.IntFunction;

public class QueueWriter<TARRAY> {
    protected QueueNode<TARRAY> tail;
    protected final int blockSize;
    private final IntFunction<TARRAY> arrayFactory;
    private TARRAY genericBlock;
    protected int begin;
    protected int current;
    protected int end;

    protected QueueWriter(int blockSize, IntFunction<TARRAY> arrayFactory, boolean concurrent) {
        int maxUnobservedBlocks = concurrent ? 4 : Integer.MAX_VALUE;
        this.tail = QueueNode.createInitial(maxUnobservedBlocks);
        this.blockSize = blockSize;
        this.arrayFactory = arrayFactory;
        this.genericBlock = null;
        this.begin = 0;
        this.current = 0;
        this.end = 0;
    }

    public void finish() {
        this.flush(true);
        this.genericBlock = null;
        this.begin = 0;
        this.current = 0;
        this.end = 0;
    }

    public void flush() {
        this.flush(false);
    }

    private void flush(boolean isLast) {
        if (!isLast && this.current == this.begin) {
            return;
        }
        this.tail = this.tail.appendNextMaybeWait(this.genericBlock, this.begin, this.current, isLast);
        this.begin = this.current;
    }

    protected final TARRAY flushAndAllocate(int sizeNeeded) {
        this.flush(false);
        int capacity = Math.max(this.blockSize, sizeNeeded);
        this.genericBlock = this.arrayFactory.apply(capacity);
        this.begin = 0;
        this.current = 0;
        this.end = capacity;
        return this.genericBlock;
    }

    public static final class ByteArrayWriter
    extends QueueWriter<byte[][]> {
        private byte[][] block = null;

        public static Pair<ByteArrayWriter, QueueReader.ByteArrayReader> create(int blockSize, boolean concurrent) {
            ByteArrayWriter writer = new ByteArrayWriter(blockSize, concurrent);
            QueueReader.ByteArrayReader reader = new QueueReader.ByteArrayReader(writer.tail);
            return new Pair<ByteArrayWriter, QueueReader.ByteArrayReader>(writer, reader);
        }

        private ByteArrayWriter(int blockSize, boolean concurrent) {
            super(blockSize, x$0 -> new byte[x$0][], concurrent);
        }

        public boolean addByteArray(byte[] value) {
            boolean flushHappened;
            boolean bl = flushHappened = this.current == this.end;
            if (flushHappened) {
                this.block = (byte[][])this.flushAndAllocate(1);
            }
            this.block[this.current++] = value;
            return flushHappened;
        }
    }

    public static final class IntWriter
    extends QueueWriter<int[]> {
        private int[] typedBlock = null;

        public static Pair<IntWriter, QueueReader.IntReader> create(int blockSize, boolean concurrent) {
            IntWriter writer = new IntWriter(blockSize, concurrent);
            QueueReader.IntReader reader = new QueueReader.IntReader(writer.tail);
            return new Pair<IntWriter, QueueReader.IntReader>(writer, reader);
        }

        private IntWriter(int blockSize, boolean concurrent) {
            super(blockSize, int[]::new, concurrent);
        }

        public boolean addInt(int value) {
            boolean flushHappened;
            boolean bl = flushHappened = this.current == this.end;
            if (flushHappened) {
                this.typedBlock = (int[])this.flushAndAllocate(1);
            }
            this.typedBlock[this.current++] = value;
            return flushHappened;
        }
    }

    public static final class ByteWriter
    extends QueueWriter<byte[]> {
        private byte[] typedBlock = null;

        public static Pair<ByteWriter, QueueReader.ByteReader> create(int blockSize, boolean concurrent) {
            ByteWriter writer = new ByteWriter(blockSize, concurrent);
            QueueReader.ByteReader reader = new QueueReader.ByteReader(writer.tail);
            return new Pair<ByteWriter, QueueReader.ByteReader>(writer, reader);
        }

        private ByteWriter(int blockSize, boolean concurrent) {
            super(blockSize, byte[]::new, concurrent);
        }

        public boolean addBytes(ByteSlice bs) {
            boolean flushHappened;
            int sliceSize = bs.size();
            if (sliceSize == 0) {
                return false;
            }
            boolean bl = flushHappened = this.current + sliceSize > this.end;
            if (flushHappened) {
                this.typedBlock = (byte[])this.flushAndAllocate(sliceSize);
            }
            bs.copyTo(this.typedBlock, this.current);
            this.current += sliceSize;
            return flushHappened;
        }
    }
}

