/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public final class BooleanAsByteParser
implements Parser<byte[]> {
    public static BooleanAsByteParser INSTANCE = new BooleanAsByteParser();

    private BooleanAsByteParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<byte[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<byte[]> sink = gctx.sinkFactory().forBooleanAsByte(gctx.colNum());
        return new Parser.ParserContext<byte[]>(sink, null, DataType.BOOLEAN_AS_BYTE, new byte[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<byte[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableBoolean booleanHolder = new MutableBoolean();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<byte[]> sink = pctx.sink();
        byte[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseBoolean(ih.bs(), booleanHolder)) break;
            gctx.clearIsNullOrWidthOneSoFar();
            values[chunkIndex] = booleanHolder.booleanValue() ? (byte)1 : 0;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

