/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.MutableObject;
import org.jetbrains.annotations.NotNull;

public final class IntParser
implements Parser<int[]> {
    public static final IntParser INSTANCE = new IntParser();

    private IntParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<int[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        MutableObject<Source<int[]>> sourceHolder = new MutableObject<Source<int[]>>();
        Sink<int[]> sink = gctx.sinkFactory().forInt(gctx.colNum(), sourceHolder);
        return new Parser.ParserContext<int[]>(sink, sourceHolder.getValue(), DataType.INT, new int[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<int[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableLong longHolder = new MutableLong();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<int[]> sink = pctx.sink();
        Integer reservedValue = gctx.sinkFactory().reservedInt();
        int[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            long value;
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseLong(ih.bs(), longHolder) || !RangeTests.isInRangeForInt(value = longHolder.longValue()) || reservedValue != null && value == (long)reservedValue.intValue()) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = (int)value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

