/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.util.CsvReaderException;
import org.jetbrains.annotations.NotNull;

public final class StringParser
implements Parser<String[]> {
    public static final StringParser INSTANCE = new StringParser();

    private StringParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<String[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<String[]> sink = gctx.sinkFactory().forString(gctx.colNum());
        return new Parser.ParserContext<String[]>(sink, null, DataType.STRING, new String[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<String[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        boolean[] nulls = gctx.nullChunk();
        Sink<String[]> sink = pctx.sink();
        String reservedValue = gctx.sinkFactory().reservedString();
        String[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            String value = ih.bs().toString();
            if (value.equals(reservedValue)) break;
            values[chunkIndex] = value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

