/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.ArraySourceAndSinkBase;

class ArrayLongSinkBase
extends ArraySourceAndSinkBase<long[]> {
    private final Long nullSentinel;

    public ArrayLongSinkBase(Long nullSentinel) {
        super(long[]::new, nullSentinel != null);
        this.nullSentinel = nullSentinel;
    }

    @Override
    protected final void nullFlagsToValues(boolean[] isNull, long[] values, int size) {
        for (int ii = 0; ii < size; ++ii) {
            if (!isNull[ii]) continue;
            values[ii] = this.nullSentinel;
        }
    }

    @Override
    protected final void nullValuesToFlags(long[] values, boolean[] isNull, int size) {
        for (int ii = 0; ii < size; ++ii) {
            isNull[ii] = values[ii] == this.nullSentinel;
        }
    }
}

