/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.Sink;
import java.lang.reflect.Array;
import java.util.function.IntFunction;

abstract class ArraySinkBase<TARRAY>
implements Sink<TARRAY> {
    private static final int INITIAL_SIZE = 1024;
    private final IntFunction<TARRAY> arrayFactory;
    protected final boolean hasNullSentinel;
    protected TARRAY array;

    protected ArraySinkBase(IntFunction<TARRAY> arrayFactory, boolean hasNullSentinel) {
        this.arrayFactory = arrayFactory;
        this.hasNullSentinel = hasNullSentinel;
        this.array = arrayFactory.apply(1024);
    }

    @Override
    public final void write(TARRAY src, boolean[] isNull, long destBegin, long destEnd, boolean appending) {
        if (destBegin == destEnd) {
            return;
        }
        int destBeginAsInt = Math.toIntExact(destBegin);
        int destEndAsInt = Math.toIntExact(destEnd);
        int destSize = Math.toIntExact(destEnd - destBegin);
        int currentCapacity = Array.getLength(this.array);
        if (currentCapacity < destEndAsInt) {
            int highBit = Integer.highestOneBit(destEndAsInt);
            int newCapacity = destEndAsInt == highBit ? highBit : highBit * 2;
            TARRAY newArray = this.arrayFactory.apply(newCapacity);
            System.arraycopy(this.array, 0, newArray, 0, currentCapacity);
            this.array = newArray;
        }
        if (this.hasNullSentinel) {
            this.nullFlagsToValues(isNull, src, destSize);
        } else {
            for (int i = 0; i < destSize; ++i) {
                if (!isNull[i]) continue;
                throw new RuntimeException("The input contains a null value, but sink is not configured with a null sentinel value");
            }
        }
        System.arraycopy(src, 0, this.array, destBeginAsInt, destSize);
    }

    @Override
    public final Object getUnderlying() {
        return this.array;
    }

    protected abstract void nullFlagsToValues(boolean[] var1, TARRAY var2, int var3);
}

