/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactoryImplBase;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.util.MutableObject;
import java.util.function.IntFunction;

final class SinkFactoryImpl<TBYTESINK extends Sink<byte[]> & Source<byte[]>, TSHORTSINK extends Sink<short[]> & Source<short[]>, TINTSINK extends Sink<int[]> & Source<int[]>, TLONGSINK extends Sink<long[]> & Source<long[]>, TFLOATSINK extends Sink<float[]>, TDOUBLESINK extends Sink<double[]>, TBOOLASBYTESINK extends Sink<byte[]>, TCHARSINK extends Sink<char[]>, TSTRINGSINK extends Sink<String[]>, TDATETIMEASLONGSINK extends Sink<long[]>, TTIMESTAMPASLONGSINK extends Sink<long[]>>
extends SinkFactoryImplBase<TFLOATSINK, TDOUBLESINK, TBOOLASBYTESINK, TCHARSINK, TSTRINGSINK, TDATETIMEASLONGSINK, TTIMESTAMPASLONGSINK> {
    private final IntFunction<TBYTESINK> byteSinkSupplier;
    private final IntFunction<TSHORTSINK> shortSinkSupplier;
    private final IntFunction<TINTSINK> intSinkSupplier;
    private final IntFunction<TLONGSINK> longSinkSupplier;

    public SinkFactoryImpl(IntFunction<TBYTESINK> byteSinkSupplier, Byte reservedByte, IntFunction<TSHORTSINK> shortSinkSupplier, Short reservedShort, IntFunction<TINTSINK> intSinkSupplier, Integer reservedInt, IntFunction<TLONGSINK> longSinkSupplier, Long reservedLong, IntFunction<TFLOATSINK> floatSinkSupplier, Float reservedFloat, IntFunction<TDOUBLESINK> doubleSinkSupplier, Double reservedDouble, IntFunction<TBOOLASBYTESINK> booleanAsByteSinkSupplier, IntFunction<TCHARSINK> charSinkSupplier, Character reservedChar, IntFunction<TSTRINGSINK> stringSinkSupplier, String reservedString, IntFunction<TDATETIMEASLONGSINK> dateTimeAsLongSinkSupplier, Long reservedDateTimeAsLong, IntFunction<TTIMESTAMPASLONGSINK> timestampAsLongSinkSupplier, Long reservedTimestampAsLong) {
        super(reservedByte, reservedShort, reservedInt, reservedLong, floatSinkSupplier, reservedFloat, doubleSinkSupplier, reservedDouble, booleanAsByteSinkSupplier, charSinkSupplier, reservedChar, stringSinkSupplier, reservedString, dateTimeAsLongSinkSupplier, reservedDateTimeAsLong, timestampAsLongSinkSupplier, reservedTimestampAsLong);
        this.byteSinkSupplier = byteSinkSupplier;
        this.shortSinkSupplier = shortSinkSupplier;
        this.intSinkSupplier = intSinkSupplier;
        this.longSinkSupplier = longSinkSupplier;
    }

    @Override
    public synchronized Sink<byte[]> forByte(int colNum, MutableObject<Source<byte[]>> source) {
        Sink result = (Sink)this.byteSinkSupplier.apply(colNum);
        source.setValue((Source)((Object)result));
        return result;
    }

    @Override
    public synchronized Sink<short[]> forShort(int colNum, MutableObject<Source<short[]>> source) {
        Sink result = (Sink)this.shortSinkSupplier.apply(colNum);
        source.setValue((Source)((Object)result));
        return result;
    }

    @Override
    public synchronized Sink<int[]> forInt(int colNum, MutableObject<Source<int[]>> source) {
        Sink result = (Sink)this.intSinkSupplier.apply(colNum);
        source.setValue((Source)((Object)result));
        return result;
    }

    @Override
    public synchronized Sink<long[]> forLong(int colNum, MutableObject<Source<long[]>> source) {
        Sink result = (Sink)this.longSinkSupplier.apply(colNum);
        source.setValue((Source)((Object)result));
        return result;
    }
}

