/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.containers;

public final class GrowableByteBuffer {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private byte[] data = new byte[1024];
    private int size = 0;

    public void append(byte[] src, int srcOffset, int srcSize) {
        this.ensure(srcSize);
        System.arraycopy(src, srcOffset, this.data, this.size, srcSize);
        this.size += srcSize;
    }

    private void ensure(int additionalSize) {
        int sizeNeeded = Math.addExact(this.size, additionalSize);
        if (sizeNeeded <= this.data.length) {
            return;
        }
        int newSize = Math.max(sizeNeeded, Math.multiplyExact(this.size, 2));
        byte[] newData = new byte[newSize];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] data() {
        return this.data;
    }

    public int size() {
        return this.size;
    }
}

