/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableDouble;
import org.jetbrains.annotations.NotNull;

public final class DoubleParser
implements Parser<double[]> {
    public static final DoubleParser INSTANCE = new DoubleParser();

    private DoubleParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<double[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<double[]> sink = gctx.sinkFactory().forDouble(gctx.colNum());
        return new Parser.ParserContext<double[]>(sink, null, DataType.DOUBLE, new double[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<double[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableDouble doubleHolder = new MutableDouble();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<double[]> sink = pctx.sink();
        Double reservedValue = gctx.sinkFactory().reservedDouble();
        double[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseDouble(ih.bs(), doubleHolder)) break;
            double value = doubleHolder.doubleValue();
            if (reservedValue != null && value == reservedValue) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

