/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.MutableDouble;
import org.jetbrains.annotations.NotNull;

public final class FloatFastParser
implements Parser<float[]> {
    public static final FloatFastParser INSTANCE = new FloatFastParser();

    private FloatFastParser() {
    }

    @Override
    @NotNull
    public Parser.ParserContext<float[]> makeParserContext(Parser.GlobalContext gctx, int chunkSize) {
        Sink<float[]> sink = gctx.sinkFactory().forFloat(gctx.colNum());
        return new Parser.ParserContext<float[]>(sink, null, DataType.FLOAT, new float[chunkSize]);
    }

    @Override
    public long tryParse(Parser.GlobalContext gctx, Parser.ParserContext<float[]> pctx, IteratorHolder ih, long begin, long end, boolean appending) throws CsvReaderException {
        MutableDouble doubleHolder = new MutableDouble();
        Tokenizer t = gctx.tokenizer();
        boolean[] nulls = gctx.nullChunk();
        Sink<float[]> sink = pctx.sink();
        Float reservedValue = gctx.sinkFactory().reservedFloat();
        float[] values = pctx.valueChunk();
        long current = begin;
        int chunkIndex = 0;
        do {
            double value;
            if (chunkIndex == values.length) {
                sink.write(values, nulls, current, current + (long)chunkIndex, appending);
                current += (long)chunkIndex;
                chunkIndex = 0;
            }
            if (current + (long)chunkIndex == end) break;
            if (gctx.isNullCell(ih)) {
                nulls[chunkIndex++] = true;
                continue;
            }
            if (!t.tryParseDouble(ih.bs(), doubleHolder) || !RangeTests.isInRangeForFloat(value = doubleHolder.doubleValue()) || reservedValue != null && value == (double)reservedValue.floatValue()) break;
            if (ih.bs().size() > 1) {
                gctx.clearIsNullOrWidthOneSoFar();
            }
            values[chunkIndex] = (float)value;
            nulls[chunkIndex] = false;
            ++chunkIndex;
        } while (ih.tryMoveNext());
        sink.write(values, nulls, current, current + (long)chunkIndex, appending);
        return current + (long)chunkIndex;
    }
}

