/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.parsers;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.DenseStorageReader;
import io.deephaven.csv.util.CsvReaderException;

public final class IteratorHolder {
    private final DenseStorageReader dsr;
    private final ByteSlice bs = new ByteSlice();
    private long numConsumed = 0L;
    private boolean isExhausted = false;

    public IteratorHolder(DenseStorageReader dsr) {
        this.dsr = dsr;
    }

    public boolean tryMoveNext() throws CsvReaderException {
        boolean bl = this.isExhausted = !this.dsr.tryGetNextSlice(this.bs);
        if (this.isExhausted) {
            return false;
        }
        ++this.numConsumed;
        return true;
    }

    public ByteSlice bs() {
        return this.bs;
    }

    public long numConsumed() {
        return this.numConsumed;
    }

    public boolean isExhausted() {
        return this.isExhausted;
    }
}

