/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.densestorage.DenseStorageReader;
import io.deephaven.csv.densestorage.DenseStorageWriter;
import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.reading.CellGrabber;
import io.deephaven.csv.reading.ParseDenseStorageToColumn;
import io.deephaven.csv.reading.ParseInputToDenseStorage;
import io.deephaven.csv.sinks.SinkFactory;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.Moveable;
import io.deephaven.csv.util.MutableBoolean;
import io.deephaven.csv.util.MutableObject;
import io.deephaven.csv.util.Pair;
import io.deephaven.csv.util.Renderer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public final class CsvReader {
    private CsvReader() {
    }

    public static Result read(CsvSpecs specs, InputStream stream, SinkFactory sinkFactory) throws CsvReaderException {
        byte quoteAsByte = (byte)specs.quote();
        byte delimiterAsByte = (byte)specs.delimiter();
        CellGrabber grabber = new CellGrabber(stream, quoteAsByte, delimiterAsByte, specs.ignoreSurroundingSpaces(), specs.trim());
        MutableObject<byte[][]> firstDataRowHolder = new MutableObject<byte[][]>();
        String[] headersTemp = CsvReader.determineHeadersToUse(specs, grabber, firstDataRowHolder);
        byte[][] firstDataRow = firstDataRowHolder.getValue();
        int numInputCols = headersTemp.length;
        String[] headersTemp2 = numInputCols != 0 && headersTemp[numInputCols - 1].isEmpty() ? Arrays.copyOf(headersTemp, numInputCols - 1) : headersTemp;
        int numOutputCols = headersTemp2.length;
        String[] headersToUse = CsvReader.canonicalizeHeaders(specs, headersTemp2);
        String[][] nullValueLiteralsToUse = new String[numOutputCols][];
        for (int ii = 0; ii < numOutputCols; ++ii) {
            nullValueLiteralsToUse[ii] = CsvReader.calcNullValueLiteralsToUse(specs, headersToUse[ii], ii).toArray(new String[0]);
        }
        DenseStorageWriter[] dsws = new DenseStorageWriter[numInputCols];
        ArrayList<Moveable<DenseStorageReader>> dsrs = new ArrayList<Moveable<DenseStorageReader>>();
        for (int ii = 0; ii < numOutputCols; ++ii) {
            Pair<DenseStorageWriter, DenseStorageReader> pair = DenseStorageWriter.create(specs.concurrent());
            dsws[ii] = (DenseStorageWriter)pair.first;
            dsrs.add(new Moveable<DenseStorageReader>((DenseStorageReader)pair.second));
        }
        ExecutorService exec = specs.concurrent() ? Executors.newFixedThreadPool(numOutputCols + 1) : Executors.newSingleThreadExecutor();
        ExecutorCompletionService<Object> ecs = new ExecutorCompletionService<Object>(exec);
        Future<Object> numRowsFuture = ecs.submit(() -> ParseInputToDenseStorage.doit(headersToUse, firstDataRow, grabber, specs, nullValueLiteralsToUse, dsws));
        ArrayList<Future<Object>> sinkFutures = new ArrayList<Future<Object>>();
        try {
            int ii = 0;
            while (ii < numOutputCols) {
                List<Parser<?>> parsersToUse = CsvReader.calcParsersToUse(specs, headersToUse[ii], ii);
                int iiCopy = ii++;
                Future<Object> fcb = ecs.submit(() -> ParseDenseStorageToColumn.doit(iiCopy, ((Moveable)dsrs.get(iiCopy)).move(), parsersToUse, specs, nullValueLiteralsToUse[iiCopy], sinkFactory));
                sinkFutures.add(fcb);
            }
            for (ii = 0; ii < numOutputCols + 1; ++ii) {
                ecs.take().get();
            }
            long numRows = (Long)numRowsFuture.get();
            ResultColumn[] resultColumns = new ResultColumn[numOutputCols];
            for (int ii2 = 0; ii2 < numOutputCols; ++ii2) {
                ParseDenseStorageToColumn.Result result = (ParseDenseStorageToColumn.Result)((Future)sinkFutures.get(ii2)).get();
                Object data = result.sink().getUnderlying();
                DataType dataType = result.dataType();
                resultColumns[ii2] = new ResultColumn(headersToUse[ii2], data, dataType);
            }
            Result result = new Result(numRows, resultColumns);
            return result;
        }
        catch (Throwable throwable) {
            throw new CsvReaderException("Caught exception", throwable);
        }
        finally {
            exec.shutdownNow();
        }
    }

    private static List<Parser<?>> calcParsersToUse(CsvSpecs specs, String columnName, int columnIndex) {
        Parser<?> specifiedParser = specs.parserForName().get(columnName);
        if (specifiedParser != null) {
            return Collections.singletonList(specifiedParser);
        }
        specifiedParser = specs.parserForIndex().get(columnIndex);
        if (specifiedParser != null) {
            return Collections.singletonList(specifiedParser);
        }
        return specs.parsers();
    }

    private static List<String> calcNullValueLiteralsToUse(CsvSpecs specs, String columnName, int columnIndex) {
        List<String> result = specs.nullValueLiteralsForName().get(columnName);
        if (result != null) {
            return result;
        }
        result = specs.nullValueLiteralsForIndex().get(columnIndex);
        if (result != null) {
            return result;
        }
        return specs.nullValueLiterals();
    }

    private static String[] determineHeadersToUse(CsvSpecs specs, CellGrabber grabber, MutableObject<byte[][]> firstDataRowHolder) throws CsvReaderException {
        byte[][] firstDataRow;
        String[] headersToUse = null;
        if (specs.hasHeaderRow()) {
            byte[][] firstRow = CsvReader.tryReadOneRow(grabber);
            if (firstRow == null) {
                throw new CsvReaderException("Can't proceed because hasHeaders is set but input file is empty");
            }
            headersToUse = (String[])Arrays.stream(firstRow).map(String::new).toArray(String[]::new);
        }
        if (specs.headers().size() != 0) {
            headersToUse = specs.headers().toArray(new String[0]);
        }
        if (headersToUse == null) {
            firstDataRow = CsvReader.tryReadOneRow(grabber);
            if (firstDataRow == null) {
                throw new CsvReaderException("Can't proceed because input file is empty and client has not specified headers");
            }
            headersToUse = new String[firstDataRow.length];
            for (int ii = 0; ii < headersToUse.length; ++ii) {
                headersToUse[ii] = "Column" + (ii + 1);
            }
        } else {
            firstDataRow = null;
        }
        for (Map.Entry<Integer, String> entry : specs.headerForIndex().entrySet()) {
            headersToUse[entry.getKey().intValue()] = entry.getValue();
        }
        firstDataRowHolder.setValue(firstDataRow);
        return headersToUse;
    }

    private static String[] canonicalizeHeaders(CsvSpecs specs, String[] headers) throws CsvReaderException {
        String[] legalized = specs.headerLegalizer().apply(headers);
        HashSet<String> unique = new HashSet<String>();
        ArrayList<String> repeats = new ArrayList<String>();
        ArrayList<String> invalidNames = new ArrayList<String>();
        for (String header : legalized) {
            if (!unique.add(header)) {
                repeats.add(header);
                continue;
            }
            if (specs.headerValidator().test(header)) continue;
            invalidNames.add(header);
        }
        if (repeats.isEmpty() && invalidNames.isEmpty()) {
            return legalized;
        }
        StringBuilder sb = new StringBuilder("Some column headers are invalid.");
        if (!repeats.isEmpty()) {
            sb.append(" Repeated headers: ");
            sb.append(Renderer.renderList(repeats));
        }
        if (!invalidNames.isEmpty()) {
            sb.append(" Invalid headers: ");
            sb.append(Renderer.renderList(invalidNames));
        }
        throw new CsvReaderException(sb.toString());
    }

    private static byte[][] tryReadOneRow(CellGrabber grabber) throws CsvReaderException {
        ArrayList<byte[]> headers = new ArrayList<byte[]>();
        ByteSlice slice = new ByteSlice();
        MutableBoolean lastInRow = new MutableBoolean();
        do {
            if (!grabber.grabNext(slice, lastInRow)) {
                return null;
            }
            byte[] item = new byte[slice.size()];
            slice.copyTo(item, 0);
            headers.add(item);
        } while (!lastInRow.booleanValue());
        return (byte[][])headers.toArray((T[])new byte[0][]);
    }

    public static final class ResultColumn {
        private final String name;
        private final Object data;
        private final DataType dataType;

        public ResultColumn(String name, Object data, DataType dataType) {
            this.name = name;
            this.data = data;
            this.dataType = dataType;
        }

        public String name() {
            return this.name;
        }

        public Object data() {
            return this.data;
        }

        public DataType dataType() {
            return this.dataType;
        }
    }

    public static final class Result
    implements Iterable<ResultColumn> {
        private final long numRows;
        private final ResultColumn[] columns;

        public Result(long numRows, ResultColumn[] columns) {
            this.numRows = numRows;
            this.columns = columns;
        }

        public long numRows() {
            return this.numRows;
        }

        public int numCols() {
            return this.columns.length;
        }

        public ResultColumn[] columns() {
            return this.columns;
        }

        @Override
        @NotNull
        public Iterator<ResultColumn> iterator() {
            return Arrays.stream(this.columns).iterator();
        }
    }
}

