/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.reading;

import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.densestorage.DenseStorageReader;
import io.deephaven.csv.parsers.DataType;
import io.deephaven.csv.parsers.IteratorHolder;
import io.deephaven.csv.parsers.Parser;
import io.deephaven.csv.parsers.Parsers;
import io.deephaven.csv.reading.TypeConverter;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactory;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.csv.util.Moveable;
import io.deephaven.csv.util.MutableBoolean;
import io.deephaven.csv.util.MutableDouble;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ParseDenseStorageToColumn {
    public static Result doit(int colNum, Moveable<DenseStorageReader> dsr, List<Parser<?>> parsers, CsvSpecs specs, String[] nullValueLiteralsToUse, SinkFactory sinkFactory) throws CsvReaderException {
        Parser nullParserToUse;
        HashSet parserSet = new HashSet(parsers != null ? parsers : Parsers.DEFAULT);
        Tokenizer tokenizer = new Tokenizer(specs.customDoubleParser(), specs.customTimeZoneParser());
        Parser.GlobalContext gctx = new Parser.GlobalContext(colNum, tokenizer, sinkFactory, nullValueLiteralsToUse);
        Moveable<IteratorHolder> ihAlt = new Moveable<IteratorHolder>(new IteratorHolder(dsr.get().copy()));
        Moveable<IteratorHolder> ih = new Moveable<IteratorHolder>(new IteratorHolder(dsr.move().get()));
        Parser parser = nullParserToUse = parserSet.size() == 1 ? (Parser)parserSet.iterator().next() : specs.nullParser();
        if (!ih.get().tryMoveNext()) {
            if (nullParserToUse == null) {
                throw new CsvReaderException("Column is empty, so can't infer type of column, and nullParser is not specified.");
            }
            ih.reset();
            ihAlt.reset();
            return ParseDenseStorageToColumn.emptyParse(nullParserToUse, gctx);
        }
        if (parserSet.size() == 1) {
            Parser parserToUse = (Parser)parserSet.iterator().next();
            ih.reset();
            return ParseDenseStorageToColumn.onePhaseParse(parserToUse, gctx, ihAlt.move());
        }
        boolean columnIsAllNulls = true;
        do {
            if (gctx.isNullCell(ih.get())) continue;
            columnIsAllNulls = false;
            break;
        } while (ih.get().tryMoveNext());
        if (columnIsAllNulls) {
            if (nullParserToUse == null) {
                throw new CsvReaderException("Column contains all null cells, so can't infer type of column, and nullParser is not specified.");
            }
            ih.reset();
            return ParseDenseStorageToColumn.onePhaseParse(nullParserToUse, gctx, ihAlt.move());
        }
        CategorizedParsers cats = CategorizedParsers.create(parserSet);
        if (cats.customParser != null) {
            ih.reset();
            return ParseDenseStorageToColumn.onePhaseParse(cats.customParser, gctx, ihAlt.move());
        }
        MutableDouble dummyDouble = new MutableDouble();
        if (!cats.numericParsers.isEmpty() && tokenizer.tryParseDouble(ih.get().bs(), dummyDouble)) {
            return ParseDenseStorageToColumn.parseNumerics(cats, gctx, ih.move(), ihAlt.move());
        }
        List<Parser> universeByPrecedence = Arrays.asList(Parsers.CHAR, Parsers.STRING);
        MutableBoolean dummyBoolean = new MutableBoolean();
        MutableLong dummyLong = new MutableLong();
        if (cats.timestampParser != null && tokenizer.tryParseLong(ih.get().bs(), dummyLong)) {
            universeByPrecedence = Arrays.asList(cats.timestampParser, Parsers.CHAR, Parsers.STRING);
        } else if (cats.booleanParser != null && tokenizer.tryParseBoolean(ih.get().bs(), dummyBoolean)) {
            universeByPrecedence = Arrays.asList(Parsers.BOOLEAN, Parsers.STRING);
        } else if (cats.dateTimeParser != null && tokenizer.tryParseDateTime(ih.get().bs(), dummyLong)) {
            universeByPrecedence = Arrays.asList(Parsers.DATETIME, Parsers.STRING);
        }
        List<Parser<?>> parsersToUse = ParseDenseStorageToColumn.limitToSpecified(universeByPrecedence, parserSet);
        return ParseDenseStorageToColumn.parseFromList(parsersToUse, gctx, ih.move(), ihAlt.move());
    }

    @NotNull
    private static Result parseNumerics(CategorizedParsers cats, Parser.GlobalContext gctx, Moveable<IteratorHolder> ih, Moveable<IteratorHolder> ihAlt) throws CsvReaderException {
        ArrayList wrappers = new ArrayList();
        for (Parser parser : cats.numericParsers) {
            ParserResultWrapper prw = ParseDenseStorageToColumn.parseNumericsHelper(parser, gctx, ih.get());
            wrappers.add(prw);
            if (!ih.get().isExhausted()) continue;
            break;
        }
        if (!ih.get().isExhausted()) {
            if (cats.charAndStringParsers.isEmpty()) {
                String message = String.format("Consumed %d numeric items, then encountered a non-numeric item but there are no char/string parsers available.", ih.get().numConsumed() - 1L);
                throw new CsvReaderException(message);
            }
            wrappers.clear();
            return ParseDenseStorageToColumn.parseFromList(cats.charAndStringParsers, gctx, ih.move(), ihAlt.move());
        }
        ih.reset();
        if (ParseDenseStorageToColumn.canUnify(wrappers)) {
            ihAlt.reset();
            return ParseDenseStorageToColumn.unifyNumericResults(gctx, wrappers);
        }
        ParserResultWrapper last = (ParserResultWrapper)wrappers.get(wrappers.size() - 1);
        return ParseDenseStorageToColumn.performSecondParsePhase(gctx, last, ihAlt.move());
    }

    private static boolean canUnify(List<ParserResultWrapper<?>> items) {
        for (int i = 0; i < items.size() - 1; ++i) {
            if (((ParserResultWrapper)items.get(i)).pctx.source() != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static <TARRAY> ParserResultWrapper<TARRAY> parseNumericsHelper(Parser<TARRAY> parser, Parser.GlobalContext gctx, IteratorHolder ih) throws CsvReaderException {
        Parser.ParserContext<TARRAY> pctx = parser.makeParserContext(gctx, 262144);
        long begin = ih.numConsumed() - 1L;
        long end = parser.tryParse(gctx, pctx, ih, begin, Long.MAX_VALUE, true);
        return new ParserResultWrapper<TARRAY>(parser, pctx, begin, end);
    }

    @NotNull
    private static Result parseFromList(List<Parser<?>> parsers, Parser.GlobalContext gctx, Moveable<IteratorHolder> ih, Moveable<IteratorHolder> ihAlt) throws CsvReaderException {
        if (parsers.isEmpty()) {
            throw new CsvReaderException("No available parsers.");
        }
        for (int ii = 0; ii < parsers.size() - 1; ++ii) {
            Pair<Result, Failure> rof = ParseDenseStorageToColumn.tryTwoPhaseParse(parsers.get(ii), gctx, ih.move(), ihAlt.move());
            if (rof.first != null) {
                return (Result)rof.first;
            }
            ih = ((Failure)rof.second).ih.move();
            ihAlt = ((Failure)rof.second).ihAlt.move();
        }
        ih.reset();
        return ParseDenseStorageToColumn.onePhaseParse(parsers.get(parsers.size() - 1), gctx, ihAlt.move());
    }

    private static <TARRAY> Pair<Result, Failure> tryTwoPhaseParse(Parser<TARRAY> parser, Parser.GlobalContext gctx, Moveable<IteratorHolder> ih, Moveable<IteratorHolder> ihAlt) throws CsvReaderException {
        long phaseOneStart = ih.get().numConsumed() - 1L;
        Parser.ParserContext<TARRAY> pctx = parser.makeParserContext(gctx, 262144);
        long end = parser.tryParse(gctx, pctx, ih.get(), phaseOneStart, Long.MAX_VALUE, true);
        if (!ih.get().isExhausted()) {
            return new Pair<Object, Failure>(null, new Failure(ih.move(), ihAlt.move()));
        }
        if (phaseOneStart == 0L) {
            Result result = new Result(pctx.sink(), pctx.dataType());
            return new Pair<Result, Object>(result, null);
        }
        ParserResultWrapper<TARRAY> wrapper = new ParserResultWrapper<TARRAY>(parser, pctx, phaseOneStart, end);
        ih.reset();
        Result result = ParseDenseStorageToColumn.performSecondParsePhase(gctx, wrapper, ihAlt.move());
        return new Pair<Result, Object>(result, null);
    }

    private static <TARRAY> Result performSecondParsePhase(Parser.GlobalContext gctx, ParserResultWrapper<TARRAY> wrapper, Moveable<IteratorHolder> ihAlt) throws CsvReaderException {
        ihAlt.get().tryMoveNext();
        long end = ((ParserResultWrapper)wrapper).parser.tryParse(gctx, ((ParserResultWrapper)wrapper).pctx, ihAlt.get(), 0L, ((ParserResultWrapper)wrapper).begin, false);
        if (end == ((ParserResultWrapper)wrapper).begin) {
            return new Result(((ParserResultWrapper)wrapper).pctx.sink(), ((ParserResultWrapper)wrapper).pctx.dataType());
        }
        String message = "Logic error: second parser phase failed on input. Parser was: " + ((ParserResultWrapper)wrapper).parser.getClass().getCanonicalName();
        throw new RuntimeException(message);
    }

    @NotNull
    private static <TARRAY> Result onePhaseParse(Parser<TARRAY> parser, Parser.GlobalContext gctx, Moveable<IteratorHolder> ihAlt) throws CsvReaderException {
        Parser.ParserContext<TARRAY> pctx = parser.makeParserContext(gctx, 262144);
        ihAlt.get().tryMoveNext();
        parser.tryParse(gctx, pctx, ihAlt.get(), 0L, Long.MAX_VALUE, true);
        if (ihAlt.get().isExhausted()) {
            return new Result(pctx.sink(), pctx.dataType());
        }
        String message = String.format("Parsing failed on input, with nothing left to fall back to. Parser %s successfully parsed %d items before failure.", parser.getClass().getCanonicalName(), ihAlt.get().numConsumed() - 1L);
        throw new CsvReaderException(message);
    }

    @NotNull
    private static <TARRAY> Result emptyParse(Parser<TARRAY> parser, Parser.GlobalContext gctx) throws CsvReaderException {
        Parser.ParserContext<TARRAY> pctx = parser.makeParserContext(gctx, 262144);
        parser.tryParse(gctx, pctx, null, 0L, 0L, true);
        return new Result(pctx.sink(), pctx.dataType());
    }

    @NotNull
    private static Result unifyNumericResults(Parser.GlobalContext gctx, List<ParserResultWrapper<?>> wrappers) {
        if (wrappers.isEmpty()) {
            throw new RuntimeException("Logic error: no parser results.");
        }
        ParserResultWrapper<?> dest = wrappers.get(wrappers.size() - 1);
        ParserResultWrapper<?> first = wrappers.get(0);
        ParseDenseStorageToColumn.fillNulls(gctx, ((ParserResultWrapper)dest).pctx, 0L, ((ParserResultWrapper)first).begin);
        long destBegin = ((ParserResultWrapper)first).begin;
        for (int ii = 0; ii < wrappers.size() - 1; ++ii) {
            ParserResultWrapper<?> curr = wrappers.get(ii);
            ParseDenseStorageToColumn.copy(gctx, ((ParserResultWrapper)curr).pctx, ((ParserResultWrapper)dest).pctx, ((ParserResultWrapper)curr).begin, ((ParserResultWrapper)curr).end, destBegin);
            destBegin += ((ParserResultWrapper)curr).end - ((ParserResultWrapper)curr).begin;
        }
        return new Result(((ParserResultWrapper)dest).pctx.sink(), ((ParserResultWrapper)dest).pctx.dataType());
    }

    private static <TARRAY, UARRAY> void copy(Parser.GlobalContext gctx, Parser.ParserContext<TARRAY> sourceCtx, Parser.ParserContext<UARRAY> destCtx, long srcBegin, long srcEnd, long destBegin) {
        TypeConverter.copy(sourceCtx.source(), destCtx.sink(), srcBegin, srcEnd, destBegin, sourceCtx.valueChunk(), destCtx.valueChunk(), gctx.nullChunk());
    }

    private static <TARRAY> void fillNulls(Parser.GlobalContext gctx, Parser.ParserContext<TARRAY> pctx, long begin, long end) {
        if (begin == end) {
            return;
        }
        boolean[] nullBuffer = gctx.nullChunk();
        Sink<TARRAY> destSink = pctx.sink();
        TARRAY values = pctx.valueChunk();
        int sizeToInit = Math.min(nullBuffer.length, Math.toIntExact(end - begin));
        Arrays.fill(nullBuffer, 0, sizeToInit, true);
        long current = begin;
        while (current != end) {
            long endToUse = Math.min(current + (long)nullBuffer.length, end);
            destSink.write(values, nullBuffer, current, endToUse, false);
            current = endToUse;
        }
    }

    private static <T> List<T> limitToSpecified(Collection<T> items, Set<T> limitTo) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            if (!limitTo.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    private static class ParserResultWrapper<TARRAY> {
        private final Parser<TARRAY> parser;
        private final Parser.ParserContext<TARRAY> pctx;
        private final long begin;
        private final long end;

        public ParserResultWrapper(Parser<TARRAY> parser, Parser.ParserContext<TARRAY> pctx, long begin, long end) {
            this.parser = parser;
            this.pctx = pctx;
            this.begin = begin;
            this.end = end;
        }
    }

    private static class CategorizedParsers {
        private final Parser<?> booleanParser;
        private final List<Parser<?>> numericParsers;
        private final Parser<?> dateTimeParser;
        private final List<Parser<?>> charAndStringParsers;
        private final Parser<?> timestampParser;
        private final Parser<?> customParser;

        public static CategorizedParsers create(Collection<Parser<?>> parsers) throws CsvReaderException {
            Parser<?> booleanParser = null;
            HashSet specifiedNumericParsers = new HashSet();
            ArrayList specifiedFloatingPointParsers = new ArrayList();
            Parser<?> dateTimeParser = null;
            HashSet specifiedCharAndStringParsers = new HashSet();
            ArrayList specifiedTimeStampParsers = new ArrayList();
            ArrayList specifiedCustomParsers = new ArrayList();
            for (Parser<?> p : parsers) {
                if (p == Parsers.BYTE || p == Parsers.SHORT || p == Parsers.INT || p == Parsers.LONG) {
                    specifiedNumericParsers.add(p);
                    continue;
                }
                if (p == Parsers.FLOAT_FAST || p == Parsers.FLOAT_STRICT || p == Parsers.DOUBLE) {
                    specifiedNumericParsers.add(p);
                    specifiedFloatingPointParsers.add(p);
                    continue;
                }
                if (p == Parsers.TIMESTAMP_SECONDS || p == Parsers.TIMESTAMP_MILLIS || p == Parsers.TIMESTAMP_MICROS || p == Parsers.TIMESTAMP_NANOS) {
                    specifiedTimeStampParsers.add(p);
                    continue;
                }
                if (p == Parsers.CHAR || p == Parsers.STRING) {
                    specifiedCharAndStringParsers.add(p);
                    continue;
                }
                if (p == Parsers.BOOLEAN) {
                    booleanParser = p;
                    continue;
                }
                if (p == Parsers.DATETIME) {
                    dateTimeParser = p;
                    continue;
                }
                specifiedCustomParsers.add(p);
            }
            if (specifiedFloatingPointParsers.size() > 1) {
                throw new CsvReaderException("There is more than one floating point parser in the parser set.");
            }
            if (specifiedTimeStampParsers.size() > 1) {
                throw new CsvReaderException("There is more than one timestamp parser in the parser set.");
            }
            if (specifiedCustomParsers.size() > 1) {
                throw new CsvReaderException("There is more than one custom parser in the parser set.");
            }
            if (!specifiedCustomParsers.isEmpty() && parsers.size() != 1) {
                throw new CsvReaderException("When a custom parser is specified, it must be the only parser in the set.");
            }
            if (!specifiedNumericParsers.isEmpty() && !specifiedTimeStampParsers.isEmpty()) {
                throw new CsvReaderException("The parser set must not contain both numeric and timestamp parsers.");
            }
            List<Parser> allNumericParsersByPrecedence = Arrays.asList(Parsers.BYTE, Parsers.SHORT, Parsers.INT, Parsers.LONG, Parsers.FLOAT_FAST, Parsers.FLOAT_STRICT, Parsers.DOUBLE);
            List<Parser> allCharAndStringParsersByPrecedence = Arrays.asList(Parsers.CHAR, Parsers.STRING);
            List numericParsers = ParseDenseStorageToColumn.limitToSpecified(allNumericParsersByPrecedence, specifiedNumericParsers);
            List charAndStringParsers = ParseDenseStorageToColumn.limitToSpecified(allCharAndStringParsersByPrecedence, specifiedCharAndStringParsers);
            Parser timestampParser = specifiedTimeStampParsers.isEmpty() ? null : (Parser)specifiedTimeStampParsers.get(0);
            Parser customParser = specifiedCustomParsers.isEmpty() ? null : (Parser)specifiedCustomParsers.get(0);
            return new CategorizedParsers(booleanParser, numericParsers, dateTimeParser, charAndStringParsers, timestampParser, customParser);
        }

        private CategorizedParsers(Parser<?> booleanParser, List<Parser<?>> numericParsers, Parser<?> dateTimeParser, List<Parser<?>> charAndStringParsers, Parser<?> timestampParser, Parser<?> customParser) {
            this.booleanParser = booleanParser;
            this.numericParsers = numericParsers;
            this.dateTimeParser = dateTimeParser;
            this.charAndStringParsers = charAndStringParsers;
            this.timestampParser = timestampParser;
            this.customParser = customParser;
        }
    }

    private static class Failure {
        public final Moveable<IteratorHolder> ih;
        public final Moveable<IteratorHolder> ihAlt;

        public Failure(Moveable<IteratorHolder> ih, Moveable<IteratorHolder> ihAlt) {
            this.ih = ih;
            this.ihAlt = ihAlt;
        }
    }

    public static class Result {
        private final Sink<?> sink;
        private final DataType dataType;

        public Result(Sink<?> sink, DataType dataType) {
            this.sink = sink;
            this.dataType = dataType;
        }

        public Sink<?> sink() {
            return this.sink;
        }

        public DataType dataType() {
            return this.dataType;
        }
    }
}

