/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.sinks;

import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactoryImplBase;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.util.MutableObject;
import java.util.function.IntFunction;

final class SinkFactorySimpleImpl<TBYTESINK extends Sink<byte[]>, TSHORTSINK extends Sink<short[]>, TINTSINK extends Sink<int[]>, TLONGSINK extends Sink<long[]>, TFLOATSINK extends Sink<float[]>, TDOUBLESINK extends Sink<double[]>, TBOOLASBYTESINK extends Sink<byte[]>, TCHARSINK extends Sink<char[]>, TSTRINGSINK extends Sink<String[]>, TDATETIMEASLONGSINK extends Sink<long[]>, TTIMESTAMPASLONGSINK extends Sink<long[]>>
extends SinkFactoryImplBase<TFLOATSINK, TDOUBLESINK, TBOOLASBYTESINK, TCHARSINK, TSTRINGSINK, TDATETIMEASLONGSINK, TTIMESTAMPASLONGSINK> {
    private final IntFunction<TBYTESINK> byteSinkSupplier;
    private final IntFunction<TSHORTSINK> shortSinkSupplier;
    private final IntFunction<TINTSINK> intSinkSupplier;
    private final IntFunction<TLONGSINK> longSinkSupplier;

    public SinkFactorySimpleImpl(IntFunction<TBYTESINK> byteSinkSupplier, Byte reservedByte, IntFunction<TSHORTSINK> shortSinkSupplier, Short reservedShort, IntFunction<TINTSINK> intSinkSupplier, Integer reservedInt, IntFunction<TLONGSINK> longSinkSupplier, Long reservedLong, IntFunction<TFLOATSINK> floatSinkSupplier, Float reservedFloat, IntFunction<TDOUBLESINK> doubleSinkSupplier, Double reservedDouble, IntFunction<TBOOLASBYTESINK> booleanAsByteSinkSupplier, IntFunction<TCHARSINK> charSinkSupplier, Character reservedChar, IntFunction<TSTRINGSINK> stringSinkSupplier, String reservedString, IntFunction<TDATETIMEASLONGSINK> dateTimeAsLongSinkSupplier, Long reservedDateTimeAsLong, IntFunction<TTIMESTAMPASLONGSINK> timestampAsLongSinkSupplier, Long reservedTimestampAsLong) {
        super(reservedByte, reservedShort, reservedInt, reservedLong, floatSinkSupplier, reservedFloat, doubleSinkSupplier, reservedDouble, booleanAsByteSinkSupplier, charSinkSupplier, reservedChar, stringSinkSupplier, reservedString, dateTimeAsLongSinkSupplier, reservedDateTimeAsLong, timestampAsLongSinkSupplier, reservedTimestampAsLong);
        this.byteSinkSupplier = byteSinkSupplier;
        this.shortSinkSupplier = shortSinkSupplier;
        this.intSinkSupplier = intSinkSupplier;
        this.longSinkSupplier = longSinkSupplier;
    }

    @Override
    public synchronized Sink<byte[]> forByte(int colNum, MutableObject<Source<byte[]>> source) {
        source.setValue(null);
        return (Sink)this.byteSinkSupplier.apply(colNum);
    }

    @Override
    public synchronized Sink<short[]> forShort(int colNum, MutableObject<Source<short[]>> source) {
        source.setValue(null);
        return (Sink)this.shortSinkSupplier.apply(colNum);
    }

    @Override
    public synchronized Sink<int[]> forInt(int colNum, MutableObject<Source<int[]>> source) {
        source.setValue(null);
        return (Sink)this.intSinkSupplier.apply(colNum);
    }

    @Override
    public synchronized Sink<long[]> forLong(int colNum, MutableObject<Source<long[]>> source) {
        source.setValue(null);
        return (Sink)this.longSinkSupplier.apply(colNum);
    }
}

