/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.tokenization;

public class RangeTests {
    public static char toUpper(char ch) {
        return RangeTests.isLower(ch) ? (char)(ch - 97 + 65) : ch;
    }

    public static boolean isUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isSpaceOrTab(byte ch) {
        return ch == 32 || ch == 9;
    }

    public static boolean isInRangeForByte(long value) {
        return value >= -128L && value <= 127L;
    }

    public static boolean isInRangeForShort(long value) {
        return value >= -32768L && value <= 32767L;
    }

    public static boolean isInRangeForInt(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    public static boolean isInRangeForFloat(double value) {
        return Double.isNaN(value) || Double.isInfinite(value) || value >= -3.4028234663852886E38 && value <= 3.4028234663852886E38;
    }

    public static boolean isAscii(byte[] data, int begin, int end) {
        for (int cur = begin; cur != end; ++cur) {
            if (data[cur] >= 0) continue;
            return false;
        }
        return true;
    }
}

