/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv.tokenization;

import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.util.MutableBoolean;
import io.deephaven.csv.util.MutableDouble;
import io.deephaven.csv.util.MutableFloat;
import io.deephaven.csv.util.MutableInt;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.MutableObject;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public class Tokenizer {
    private final CustomDoubleParser customDoubleParser;
    private final CustomTimeZoneParser customTimeZoneParser;
    private final MutableLong dateTimeTemp0 = new MutableLong();
    private final MutableLong dateTimeTemp1 = new MutableLong();
    private final MutableLong dateTimeTemp2 = new MutableLong();
    private final MutableObject<ZoneId> dateTimeTempZoneId = new MutableObject();
    private final MutableBoolean dateTimeTempBoolean = new MutableBoolean();

    public Tokenizer(CustomDoubleParser customDoubleParser, CustomTimeZoneParser customTimeZoneParser) {
        this.customDoubleParser = Objects.requireNonNull(customDoubleParser);
        this.customTimeZoneParser = customTimeZoneParser;
    }

    public boolean tryParseBoolean(ByteSlice bs, MutableBoolean result) {
        int savedBegin = bs.begin();
        int savedEnd = bs.end();
        Mutating.trim(bs);
        boolean success = Mutating.tryParseBoolean(bs, result) && bs.begin() == bs.end();
        bs.setBegin(savedBegin);
        bs.setEnd(savedEnd);
        return success;
    }

    public boolean tryParseBMPChar(ByteSlice bs, MutableInt result) {
        int moreExpected;
        int value;
        int first;
        int end;
        byte[] d = bs.data();
        int o = bs.begin();
        if (o == (end = bs.end())) {
            return false;
        }
        if (((first = Tokenizer.byteToInt(d[o++])) & 0x80) == 0) {
            int value2 = first & 0x7F;
            result.setValue(value2);
            return o == end;
        }
        if ((first & 0xE0) == 192) {
            value = first & 0x1F;
            moreExpected = 1;
        } else if ((first & 0xF0) == 224) {
            value = first & 0xF;
            moreExpected = 2;
        } else {
            return false;
        }
        for (int ii = 0; ii < moreExpected; ++ii) {
            int next;
            if (o == end) {
                return false;
            }
            if (((next = Tokenizer.byteToInt(d[o++])) & 0xC0) != 128) {
                return false;
            }
            value = value << 6 | next & 0x3F;
        }
        result.setValue(value);
        return true;
    }

    private static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public boolean tryParseLong(ByteSlice bs, MutableLong result) {
        int savedBegin = bs.begin();
        int savedEnd = bs.end();
        Mutating.trim(bs);
        boolean success = Mutating.tryParseLong(bs, result) && bs.begin() == bs.end();
        bs.setBegin(savedBegin);
        bs.setEnd(savedEnd);
        return success;
    }

    public boolean tryParseFloatStrict(ByteSlice bs, MutableFloat result) {
        try {
            float res = Float.parseFloat(bs.toString());
            result.setValue(res);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public boolean tryParseDouble(ByteSlice bs, MutableDouble result) {
        try {
            double res = this.customDoubleParser.parse(bs);
            result.setValue(res);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public boolean tryParseDateTime(ByteSlice bs, MutableLong result) {
        int savedBegin = bs.begin();
        boolean success = Mutating.tryParseDateTime(bs, this.customTimeZoneParser, this.dateTimeTemp0, this.dateTimeTemp1, this.dateTimeTemp2, this.dateTimeTempBoolean, this.dateTimeTempZoneId, result) && bs.begin() == bs.end();
        bs.setBegin(savedBegin);
        return success;
    }

    public static interface CustomDoubleParser {
        public static Optional<CustomDoubleParser> load() {
            Iterator<CustomDoubleParser> it = ServiceLoader.load(CustomDoubleParser.class).iterator();
            if (!it.hasNext()) {
                return Optional.empty();
            }
            CustomDoubleParser first = it.next();
            if (it.hasNext()) {
                CustomDoubleParser second = it.next();
                throw new IllegalStateException(String.format("Found more than one service registered for '%s': '%s' and '%s'", CustomDoubleParser.class.getName(), first.getClass().getName(), second.getClass().getName()));
            }
            return Optional.of(first);
        }

        public double parse(ByteSlice var1) throws NumberFormatException;

        public double parse(CharSequence var1) throws NumberFormatException;
    }

    public static interface CustomTimeZoneParser {
        public boolean tryParse(ByteSlice var1, MutableObject<ZoneId> var2, MutableLong var3);
    }

    private static final class Mutating {
        private Mutating() {
        }

        public static void trim(ByteSlice bs) {
            while (bs.begin() != bs.end() && RangeTests.isSpaceOrTab(bs.front())) {
                bs.setBegin(bs.begin() + 1);
            }
            while (bs.begin() != bs.end() && RangeTests.isSpaceOrTab(bs.back())) {
                bs.setEnd(bs.end() - 1);
            }
        }

        private static boolean tryEatChar(ByteSlice bs, char ch) {
            if (bs.begin() == bs.end() || bs.front() != ch) {
                return false;
            }
            bs.setBegin(bs.begin() + 1);
            return true;
        }

        public static boolean tryParseBoolean(ByteSlice bs, MutableBoolean result) {
            byte[] d = bs.data();
            int o = bs.begin();
            int bSize = bs.size();
            if (bSize == 4) {
                if (!(d[o] != 116 && d[o] != 84 || d[o + 1] != 114 && d[o + 1] != 82 || d[o + 2] != 117 && d[o + 2] != 85 || d[o + 3] != 101 && d[o + 3] != 69)) {
                    result.setValue(true);
                    bs.setBegin(bs.end());
                    return true;
                }
                return false;
            }
            if (bSize == 5) {
                if (!(d[o] != 102 && d[o] != 70 || d[o + 1] != 97 && d[o + 1] != 65 || d[o + 2] != 108 && d[o + 2] != 76 || d[o + 3] != 115 && d[o + 3] != 83 || d[o + 4] != 101 && d[o + 4] != 69)) {
                    result.setValue(false);
                    bs.setBegin(bs.end());
                    return true;
                }
                return false;
            }
            return false;
        }

        public static boolean tryParseLong(ByteSlice bs, MutableLong result) {
            int savedBegin = bs.begin();
            if (bs.begin() == bs.end()) {
                return false;
            }
            char front = (char)bs.front();
            boolean negative = false;
            if (front == '+') {
                bs.setBegin(bs.begin() + 1);
            } else if (front == '-') {
                negative = true;
                bs.setBegin(bs.begin() + 1);
            }
            if (!Mutating.tryParseWholeNumber(bs, 1, 999, negative, result)) {
                bs.setBegin(savedBegin);
                return false;
            }
            return true;
        }

        private static boolean tryParseDateTime(ByteSlice bs, CustomTimeZoneParser customTimeZoneParser, MutableLong temp0, MutableLong temp1, MutableLong temp2, MutableBoolean tempBoolean, MutableObject<ZoneId> tempZoneId, MutableLong result) {
            int savedBegin = bs.begin();
            if (!Mutating.tryParseYyyymmdd(bs, temp0, temp1, temp2, tempBoolean)) {
                return false;
            }
            int year = temp0.intValue();
            int month = temp1.intValue();
            int day = temp2.intValue();
            boolean punctuationRequired = tempBoolean.booleanValue();
            if (!Mutating.tryEatChar(bs, 'T') && !Mutating.tryEatChar(bs, ' ')) {
                bs.setBegin(savedBegin);
                return false;
            }
            if (!Mutating.tryParseHHmmssNanos(bs, punctuationRequired, temp0, temp1, temp2, result)) {
                bs.setBegin(savedBegin);
                return false;
            }
            int hour = temp0.intValue();
            int minute = temp1.intValue();
            int second = temp2.intValue();
            int nanos = result.intValue();
            if (!(Mutating.tryParseIsoTimeZone(bs, tempZoneId, temp0) || customTimeZoneParser != null && customTimeZoneParser.tryParse(bs, tempZoneId, temp0))) {
                bs.setBegin(savedBegin);
                return false;
            }
            ZoneId zoneIdToUse = tempZoneId.getValue();
            long secondsOffsetToUse = temp0.longValue();
            ZonedDateTime zdt = ZonedDateTime.of(year, month, day, hour, minute, second, 0, zoneIdToUse);
            long zdtSeconds = zdt.toEpochSecond();
            long adjustedZdtSeconds = zdtSeconds + secondsOffsetToUse;
            long adjustedZdtNanos = adjustedZdtSeconds * 1000000000L + (long)nanos;
            result.setValue(adjustedZdtNanos);
            return true;
        }

        private static boolean tryParseYyyymmdd(ByteSlice bs, MutableLong yyyy, MutableLong mm, MutableLong dd, MutableBoolean hasPunctuation) {
            int savedBegin = bs.begin();
            if (!Mutating.tryParseWholeNumber(bs, 4, 4, false, yyyy)) {
                return false;
            }
            hasPunctuation.setValue(Mutating.tryEatChar(bs, '-'));
            if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, mm)) {
                bs.setBegin(savedBegin);
                return false;
            }
            if (hasPunctuation.booleanValue() && !Mutating.tryEatChar(bs, '-')) {
                bs.setBegin(savedBegin);
                return false;
            }
            if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, dd)) {
                bs.setBegin(savedBegin);
                return false;
            }
            return true;
        }

        private static boolean tryParseHHmmssNanos(ByteSlice bs, boolean punctuationRequired, MutableLong hours, MutableLong minutes, MutableLong seconds, MutableLong nanos) {
            int length;
            int savedBegin = bs.begin();
            if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, hours)) {
                return false;
            }
            minutes.setValue(0L);
            seconds.setValue(0L);
            nanos.setValue(0L);
            if (punctuationRequired && !Mutating.tryEatChar(bs, ':')) {
                return true;
            }
            if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, minutes)) {
                boolean success;
                minutes.setValue(0L);
                boolean bl = success = !punctuationRequired;
                if (!success) {
                    bs.setBegin(savedBegin);
                }
                return success;
            }
            if (punctuationRequired && !Mutating.tryEatChar(bs, ':')) {
                return true;
            }
            if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, seconds)) {
                boolean success;
                seconds.setValue(0L);
                boolean bl = success = !punctuationRequired;
                if (!success) {
                    bs.setBegin(savedBegin);
                }
                return success;
            }
            if (!Mutating.tryEatChar(bs, '.') && !Mutating.tryEatChar(bs, ',')) {
                return true;
            }
            int beginBeforeNs = bs.begin();
            if (!Mutating.tryParseWholeNumber(bs, 1, 9, false, nanos)) {
                bs.setBegin(savedBegin);
                return false;
            }
            for (int ii = length = bs.begin() - beginBeforeNs; ii < 9; ++ii) {
                nanos.setValue(10L * nanos.longValue());
            }
            return true;
        }

        private static boolean tryParseWholeNumber(ByteSlice bs, int minSize, int maxSize, boolean negate, MutableLong result) {
            char ch;
            int current;
            byte[] data = bs.data();
            int begin = bs.begin();
            int end = bs.end();
            int size = bs.size();
            if (size < minSize) {
                return false;
            }
            int endToUse = Math.min(end, begin + maxSize);
            long res = 0L;
            long prevRes = 0L;
            for (current = begin; current < endToUse && RangeTests.isDigit(ch = (char)data[current]); ++current) {
                if ((res = res * 10L - (long)(ch - 48)) > prevRes) {
                    return false;
                }
                prevRes = res;
            }
            if (current == begin) {
                return false;
            }
            if (!negate) {
                if (res == Long.MIN_VALUE) {
                    return false;
                }
                res = -res;
            }
            result.setValue(res);
            bs.setBegin(current);
            return true;
        }

        private static boolean tryParseIsoTimeZone(ByteSlice bs, MutableObject<ZoneId> zoneId, MutableLong offsetSeconds) {
            if (bs.size() == 0) {
                return false;
            }
            char front = (char)bs.front();
            if (front == 'Z') {
                zoneId.setValue(ZoneOffset.UTC);
                offsetSeconds.setValue(0L);
                bs.setBegin(bs.begin() + 1);
                return true;
            }
            if (front != '+' && front != '-') {
                return false;
            }
            boolean negative = front == '-';
            int savedBegin = bs.begin();
            bs.setBegin(bs.begin() + 1);
            if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, offsetSeconds)) {
                bs.setBegin(savedBegin);
                return false;
            }
            long hours = offsetSeconds.longValue();
            Mutating.tryEatChar(bs, ':');
            long minutes = 0L;
            if (bs.size() != 0) {
                if (!Mutating.tryParseWholeNumber(bs, 2, 2, false, offsetSeconds)) {
                    bs.setBegin(savedBegin);
                    return false;
                }
                minutes = offsetSeconds.longValue();
            }
            zoneId.setValue(ZoneOffset.UTC);
            long offset = (hours * 60L + minutes) * 60L;
            offsetSeconds.setValue(negative ? offset : -offset);
            return true;
        }
    }
}

