/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.exceptions;

import java.util.Collection;

public class NotSortableException
extends RuntimeException {
    public NotSortableException(Collection<String> unsortableColumns, Collection<String> sortableColumns) {
        super(NotSortableException.buildErrorMessage(unsortableColumns, sortableColumns));
    }

    private static String buildErrorMessage(Collection<String> unsortableColumns, Collection<String> sortableColumns) {
        Object message = sortableColumns.isEmpty() ? "Sorting is not allowed on this table" : "Sorting is not allowed on this table, but was attempted on: " + String.join((CharSequence)", ", unsortableColumns);
        message = (String)message + " but was attempted on: " + String.join((CharSequence)", ", unsortableColumns);
        return message;
    }
}

