/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.exceptions;

import io.deephaven.auth.AuthContext;
import io.deephaven.engine.exceptions.UncheckedPermissionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableAccessException
extends UncheckedPermissionException {
    public TableAccessException(String reason) {
        super(reason);
    }

    public TableAccessException(@NotNull String tableDescription, @NotNull AuthContext authContext) {
        this(tableDescription, authContext, "");
    }

    public TableAccessException(@NotNull String tableDescription, @NotNull AuthContext authContext, @Nullable String reason) {
        super(TableAccessException.makeDescription(tableDescription, authContext, reason));
    }

    private static String makeDescription(@NotNull String tableDescription, @NotNull AuthContext authContext, @Nullable String reason) {
        StringBuilder sb = new StringBuilder();
        sb.append(authContext).append(" may not access: ");
        sb.append(tableDescription);
        if (reason != null && !reason.isEmpty()) {
            sb.append(": ").append(reason);
        }
        return sb.toString();
    }
}

